/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.beanCopy.defaultTypeConverter;

import com.baijia.tianxiao.beanCopy.Typeconverter;
import com.baijia.tianxiao.util.date.TimeStamp;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.Date;

public class Long2DataConverter
extends Typeconverter {
    @Override
    public Object convert(String fieldName, Type sourceFieldType, Type destFieldType, Object value) {
        super.checkConvertTypes(sourceFieldType, destFieldType);
        Object setValue = value;
        if (value != null) {
            if (this.matchNumberType(sourceFieldType)) {
                if (destFieldType == Date.class) {
                    setValue = new Date((Long)value);
                } else if (destFieldType == Timestamp.class) {
                    setValue = new Timestamp((Long)value);
                } else if (destFieldType == java.sql.Date.class) {
                    setValue = new java.sql.Date((Long)value);
                }
            } else if (this.matchDateType(sourceFieldType)) {
                if (sourceFieldType == Date.class) {
                    setValue = ((Date)value).getTime();
                } else if (sourceFieldType == Timestamp.class) {
                    setValue = ((Timestamp)value).getTime();
                } else if (sourceFieldType == java.sql.Date.class) {
                    setValue = ((java.sql.Date)value).getTime();
                }
                if (destFieldType == Integer.TYPE || destFieldType == Integer.class) {
                    return ((Long)setValue).intValue();
                }
            }
        }
        return setValue;
    }

    private boolean matchDateType(Type sourceFieldType) {
        return sourceFieldType == Date.class || sourceFieldType == java.sql.Date.class || sourceFieldType == TimeStamp.class;
    }

    private boolean matchNumberType(Type sourceFieldType) {
        return sourceFieldType == Long.class || sourceFieldType == Long.TYPE || sourceFieldType == Integer.class || sourceFieldType == Integer.TYPE;
    }
}

