package com.baijia.tianxiao.util.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.WeakHashMap;

public class PropertiesReader {

    private static Map<String, Properties> filePropMapping = new WeakHashMap<String, Properties>();

    public static String getValue(String file_name, String key) throws MissingResourceException {
        final ResourceBundle res = ResourceBundle.getBundle(file_name);
        String value = res.getString(key);
        return value.trim();
    }

    /**
     * 每次从文件重新读取，不缓存
     * 
     * @author shizuwei
     * @param file_name
     * @param key
     * @return
     * @throws RuntimeException
     */
    public static String getValueNoCache(String file_name, String key) {
        InputStream fileInputStream = null;
        try {
            fileInputStream = PropertiesReader.class.getClassLoader().getResourceAsStream(file_name);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            String value = properties.getProperty(key);
            return value.trim();
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        } finally {
            try {
                fileInputStream.close();
            } catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    public static void main(String args[]) {
        System.out.println(getValueNoCache("erp.properties", "course.colors"));
        System.out.println(getValue("jigou", "org_tag"));

    }

    public static Properties fillProperties(String file_name) throws MissingResourceException {

        if (!file_name.endsWith(".properties")) {
            file_name = file_name + ".properties";
        }
        return getProperties(file_name);
    }

    public static Properties getProperties(String fileName) {

        return getProperties(fileName, PropertiesReader.class.getClassLoader());
    }

    public static Properties getProperties(String fileName, ClassLoader cl) {

        Properties properties = new Properties();

        if (filePropMapping.containsKey(fileName)) {
            properties = filePropMapping.get(fileName);
        } else {
            InputStream is = cl.getResourceAsStream(fileName);
            try {
                try {
                    properties.load(is);
                } catch (IOException e) {
                    throw new RuntimeException("load properties file error", e);
                }
                filePropMapping.put(fileName, properties);
            } finally {
                try {
                    is.close();
                } catch (IOException e) {
                    throw new RuntimeException("load properties file error", e);
                }
            }

        }
        return properties;
    }
}
