package com.baijia.tianxiao.util.http;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;

import javax.xml.ws.WebServiceException;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.util.encrypt.HMACUtils;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;

/**
 * @title GSXService
 * @desc TODO
 * @author wangzhigang
 * @date 2014年12月3日
 * @version 1.0
 */
public class GSXService {

	private static final Logger logger = LoggerFactory.getLogger(GSXService.class);

	private static final String CHAR_SET = "UTF-8";
	private static final String CONNECTOR = "-";

	private static final long EXPIRE_TIME = 1000 * 60 * 5;

	public static volatile String authToken = null;
	public static volatile long loginTime = -1;

	public static final String appId;
	public static final String appKey;
	public static final String url;

	static {
		Properties properties = PropertiesReader.getProperties("rest.properties");
		appId = properties.getProperty("webservice.app_id");
		appKey = properties.getProperty("webservice.app_key");
		url = properties.getProperty("webservice.url");
	}

	public enum RequestMethod {
		GET("get"), POST("post");
		private String method;

		private RequestMethod(String method) {
			this.method = method;
		}

		public String getMethod() {
			return this.method;
		}
	}

	public static <T> RestfulResult<T> doService(String controller, String action, SortedMap<String, String> params) {
		try {
			String token = requestAuthToken();
			int timestamp = (int) (System.currentTimeMillis() / 1000);
			params.put("app_id", appId);
			params.put("auth_token", token);
			params.put("timestamp", String.valueOf(timestamp));
			String response = request(controller, action, params);
			logger.info("response:{}", response);
			if (StringUtils.isBlank(response)) {
				return null;
			}
			@SuppressWarnings("unchecked")
			RestfulResult<T> result = JacksonUtil.str2Obj(response, RestfulResult.class);

			return result;
		} catch (Exception e) {
			logger.warn("call webservice catch error:{}", e);
			throw new WebServiceException(e);
		}
	}

	@SuppressWarnings("unchecked")
	private static String requestAuthToken() {
		if (loginTime - System.currentTimeMillis() < EXPIRE_TIME && authToken != null) {
			return authToken;
		}

		final String controller = "auth";
		final String action = "login";
		int timestamp = (int) (System.currentTimeMillis() / 1000);

		SortedMap<String, String> params = new TreeMap<String, String>();
		params.put("app_id", appId);
		params.put("app_key", appKey);
		params.put("timestamp", String.valueOf(timestamp));

		String response = request(controller, action, params);
		logger.info("response:{}", response);

		if (StringUtils.isBlank(response)) {
			throw new IllegalStateException("request auth token is null, " + params.toString());
		}
		try {
			Map<String, Object> json = JacksonUtil.str2Obj(response, Map.class);
			Number code = (Number) json.get("code");
			if (code.intValue() != 0) {
				throw new WebServiceException("auth failed - app_id:" + appId + ", app_key:" + appKey);
			}
			Map<String, String> tokenMap = (Map<String, String>) json.get("data");
			authToken = tokenMap.get("auth_token");
			loginTime = System.currentTimeMillis();
			return authToken;
		} catch (IOException e) {
			throw new RuntimeException(e);
		}

	}

	private static String request(String controller, String action, SortedMap<String, String> params) {
		String reqUrl = url + "/" + controller + "/" + action;

		StringBuilder signSb = new StringBuilder();
		signSb.append(RequestMethod.POST.getMethod()).append(CONNECTOR).append(controller).append(CONNECTOR)
				.append(action);
		for (String key : params.keySet()) {
			String value = params.get(key);
			signSb.append(CONNECTOR).append(value);
		}

		try {
			String sign = HMACUtils.encrypt(signSb.toString().getBytes(CHAR_SET), appKey.toString().getBytes(CHAR_SET));
			params.put("sign", sign);
		} catch (Exception e) {
			throw new WebServiceException(e);
		}

		long t1 = System.currentTimeMillis();
		String response = HttpClientUtils.doPost(reqUrl, params);
		long t2 = System.currentTimeMillis();
		logger.info("request - url:{}, params:{}, time:{}", reqUrl, params, (t2 - t1));
		return response;
	}
}
