/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;

import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;

/**
 * @author cxm
 * @version 1.0
 * @title NumberUtil
 * @desc TODO
 * @date 2015年11月28日
 */
@Slf4j
public class NumberUtil {

    public static DecimalFormat DOUBLE_FMT = new DecimalFormat("0.00");

    public static BigDecimal multiply(@NonNull Number number1, @NonNull BigDecimal bigDecimal, int scale) {
        BigDecimal d1 = new BigDecimal(number1.doubleValue());
        return d1.multiply(bigDecimal).setScale(scale, RoundingMode.HALF_UP);

    }

    /**
     * 计算环比数据 (n1-n2)/n2
     */
    public static BigDecimal getHuanBi(Number n1, Number n2) {
        BigDecimal result = BigDecimal.ZERO;
        try {
            BigDecimal b2 = BigDecimal.valueOf(n2.doubleValue());
            if (n2 == null || b2.compareTo(new BigDecimal(0)) == 0) {
                return new BigDecimal(0);
            }

            BigDecimal b1 = BigDecimal.valueOf(n1.doubleValue());

            result = (b1.subtract(b2).divide(b2, 2, BigDecimal.ROUND_HALF_EVEN));
        } catch (Exception e) {
            log.error("[Divide] Error.", e);
        }
        return result;
    }

    //保留2位小数
    public static double get2Double(double a) {
        DecimalFormat df = new DecimalFormat("0.00");
        return new Double(df.format(a).toString());
    }

    public static void main(String[] args) {
        System.out.println(getHuanBi(10, 0.0000));
        Number n = 1.00;
        System.out.println(n.toString());

        System.out.println(Long.parseLong("501701126786409482"));
    }
    /**
     * 将double类型保留两位小数并转换为带千分号的字符串
     */
    public static String numberWithDelimiter(double d) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        String s = decimalFormat.format(d);
        //如果长度小于等于3不做处理
        if (s.length() <= 3){
            return s; 
        }
        StringBuilder sb = new StringBuilder();
        //如果为负数
        if(s.startsWith("-")){
            sb.append(s.substring(1));
        }else{
            sb.append(s);
        }
        int index = sb.toString().indexOf(".");
        //从个位开始倒序插入
        while ((index = index - 3) > 0) { 
            sb.insert(index, ",");
        }
        //如果为负数，添加符号
        if(s.startsWith("-")){
            sb.insert(0, "-");
        }else{
            sb.insert(0, "+");
        }
        return sb.toString();
    }
    
    //保留2位小数
    public static String get2FromDouble(double a) {
        DecimalFormat df = new DecimalFormat("0.00");
        return df.format(a);
    }
}
