package com.baijia.tianxiao.util;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;

/**
 * Created by liuxp on 16/12/12.
 */

@Slf4j
public class CollectionHelper {
    public static <T> Map<Long,T> toIdMap(Collection<T> collection){
        return CollectionUtils.extractMap(collection, new CollectionUtils.Extracter<Long, T>() {
            @Override
            public Long extract(T t) {
                try {
                    Field field = t.getClass().getDeclaredField("id");
                    field.setAccessible(true);
                    Long value = (Long) field.get(t);
                    return value;
                } catch (NoSuchFieldException e) {
                    log.error("ToIdMap exception ",e);
                } catch (IllegalAccessException e) {
                    log.error("ToIdMap exception ",e);
                }
                throw new RuntimeException("ToIdMap exception");
            }
        });
    }
}
