/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.exception;

import com.baijia.tianxiao.dto.UniverseErrorCode;


/**   
 * @Title       : WebServiceException 
 * @Description : 外部调用异常 网络请求异常
 * @Author      : zhenyujian
 * @Date        : 2015年12月1日 下午2:44:18 
 */
public class WebServiceException extends CustomException {

	private static final long serialVersionUID = 5908057893941481390L;
	

	public WebServiceException(UniverseErrorCode errorCode) {
        this.errorCode = errorCode;
    }
	
	public WebServiceException(String message) {
        this.message = message;
    }
	
	public WebServiceException(Throwable cause) {
        this.addSuppressed(cause);
    }
    
    public WebServiceException(String message, UniverseErrorCode errorCode) {
        this.message = message;
        this.errorCode = errorCode;
    }
    
    public WebServiceException(String message, Throwable cause) {
        this.message = message;
        this.addSuppressed(cause);
    }
    
}




