package com.baijia.tianxiao.enums;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.util.ErrorCodeUtil;

/**
 * 
 * @title SendMsgErrorCode
 * @desc TODO
 * @author cxm
 * @date 2016年3月21日
 * @version 1.0
 */
public enum SendMsgErrorCode implements UniverseErrorCode {

    PARAM_ERROR(ErrorSide.CLIENT, Subsystem.MSG_CENTER, Platform.UNKNOW, 400, "请求参数不合法"),

    MOBILE_INVALIDATE(ErrorSide.CLIENT, Subsystem.MSG_CENTER, Platform.UNKNOW, 405, "手机号码格式不正确"),

    MSG_CONTENT_EMPTY(ErrorSide.CLIENT, Subsystem.MSG_CENTER, Platform.UNKNOW, 402, "消息内容为空"),

    SENDER_ERROR(ErrorSide.CLIENT, Subsystem.MSG_CENTER, Platform.UNKNOW, 403, "发送人信息错误"),

    RECEIVER_ERROR(ErrorSide.CLIENT, Subsystem.MSG_CENTER, Platform.UNKNOW, 408, "接收人信息错误"),

    NOT_SMS_COUNT(ErrorSide.CLIENT, Subsystem.MSG_CENTER, Platform.UNKNOW, 500, "短信条数不足"),

    SYSTEM_ERROR(ErrorSide.SERVER, Subsystem.MSG_CENTER, Platform.UNKNOW, 9999, "系统处理异常");

    private ErrorSide errorSide;
    private Subsystem subsystem;
    private Platform platform;
    private int code;
    private String message;

    private SendMsgErrorCode(ErrorSide errorSide, Subsystem subsystem, Platform platform, int code, String msg) {
        this.errorSide = errorSide;
        this.subsystem = subsystem;
        this.platform = platform;
        this.code = code;
        this.message = msg;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getErrorSide()
     */
    @Override
    public ErrorSide getErrorSide() {
        return errorSide;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getSystem()
     */
    @Override
    public Subsystem getSystem() {
        return subsystem;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getPlatform()
     */
    @Override
    public Platform getPlatform() {
        return platform;
    }

    @Override
    public int getSubsystemErrorCode() {
        return code;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public SendMsgErrorCode fromCode(int code) {
        for (SendMsgErrorCode errorCode : values()) {
            if (errorCode.getSubsystemErrorCode() == code) {
                return errorCode;
            }
        }
        return SendMsgErrorCode.SYSTEM_ERROR;
    }

    public static void main(String args[]) {
        System.out.println(ErrorCodeUtil.getUniverseErrorCode(PARAM_ERROR));
    }
}
