package com.baijia.tianxiao.constants;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created with IntelliJ IDEA. User: Victor Weng 短信根据不同的机构对应的不同后缀和网关,土豪机构定制 Date: 16/8/2 Time: 下午4:28 To change this
 * template use File | Settings | File Templates.
 */
public enum SmsGateGroup {

    TEST(55674, "14", "乐之教育"),

    LEZHIJIIAOYU1(57689, "14", "乐之教育"),

    SIXUEJIAJIAOYU(61837, "18", "思学佳教育"),
    SIXUEJIAJIAOYU1(62382, "18", "思学佳教育"),
    SIXUEJIAJIAOYU2(62383, "18", "思学佳教育"),
    SIXUEJIAJIAOYU3(62456, "18", "思学佳教育");

    public static Integer DEFAULT_SMS_GATE= 6;//天校后缀短信发送默认网关6

    private Integer orgId;// 机构ID

    private String orgName = "";// 机构名称

    private String geteway;

    private static final Map<Integer, SmsGateGroup> map = Maps.newHashMap();

    static {
        for (SmsGateGroup smsGateGroup : SmsGateGroup.values()) {
            map.put(smsGateGroup.getOrgId(), smsGateGroup);
        }
    }

    SmsGateGroup(Integer orgId, String gateway, String orgName) {
        this.orgId = orgId;
        this.geteway = gateway;
        this.orgName = orgName;
    }

    public Integer getOrgId() {
        return orgId;
    }

    public void setOrgId(Integer orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getGeteway() {
        return geteway;
    }

    public void setGeteway(String geteway) {
        this.geteway = geteway;
    }

    public static SmsGateGroup getByOrgId(Integer orgId) {
        return map.get(orgId.intValue());
    }
}
