package com.baijia.tianxiao.util.pay;

import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;
import java.util.Properties;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/7/11
 * Time: 下午1:27
 * To change this template use File | Settings | File Templates.
 */
@Slf4j
public class PayHttpRestUtil {

    public static final String PAY_SERVICE;

    public static final String API_PAY_RUL;

    static {
        Properties prop = com.baijia.commons.lang.utils.PropertiesReader.fillProperties("rest.properties");
        PAY_SERVICE = prop.getProperty("rest.appServiceUrl.new");
        API_PAY_RUL = PAY_SERVICE + "/pay/api";
    }

    public static Object rest(String url, Map<String, String> params) throws BussinessException {
        RestfulResult<Object> restfulResult = null;

        try {
            log.info("payHttpRestUtil params== {}", params);
            String resultJson = HttpClientUtils.doPost(url, params);
            if(resultJson==null){
                return null;
            }
            log.info("payHttpRestUtil result={}", resultJson);
            restfulResult = JacksonUtil.str2Obj(resultJson, RestfulResult.class);
            if (restfulResult.getCode() != 0) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, restfulResult.getMsg());
            }
        } catch (Exception e) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, restfulResult.getMsg());
        }
        return restfulResult.getData();
    }
}
