package com.baijia.tianxiao.excel.dto;

import java.util.List;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

@Data
public class ExportField {
    /**
     * Excel的列名称,不能为空
     */
    private String name;

    /**
     * excel展示的数据格式
     */
    private String format = "@";

    /**
     * 对应的属性,如果不设置,通过下标获取.
     */
    private String prop;

    private int width;

    private Object defaultVal;

    private List<ExportField> children;

    public int getWidth() {
        if (width == 0 && StringUtils.isNoneBlank(name)) {
            return name.length() * 256;
        }
        return width;
    }

    public int getExportFieldSize() {
        if (CollectionUtils.isEmpty(children)) {
            return 1;
        } else {
            int size = 0;
            for (ExportField child : children) {
                size += child.getExportFieldSize();
            }
            return size;
        }
    }

    public ExportField() {
    }

    public ExportField(String name, String format, int width) {
        this.name = name;
        this.format = format;
        this.width = width;
    }

    public ExportField(String name, String format, int width, Object defaultVal) {
        this.name = name;
        this.format = format;
        this.width = width;
        this.defaultVal = defaultVal;
    }
}
