/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.enums;

import com.baijia.tianxiao.dto.UniverseErrorCode;

/**
 * @title SMSErrorCode
 * @desc O(∩_∩)O~ 
 * @author caoliang
 * @date 2016年5月14日
 * @version 1.0
 */
    
public enum SMSErrorCode implements UniverseErrorCode {

    UNKNOW(ErrorSide.UNKNOW, Subsystem.COMMON, Platform.UNKNOW, 990001, "未知类型错误"),

    SMS_INTERVAL_ERROR(ErrorSide.CLIENT, Subsystem.COMMON, Platform.UNKNOW, 990002, "一分钟只能发送一次"),

    SMS_TYPE_INVALID(ErrorSide.CLIENT, Subsystem.COMMON, Platform.UNKNOW, 990003, "短信类型不合法"),
    
    CODE_INVALID(ErrorSide.CLIENT, Subsystem.COMMON, Platform.UNKNOW, 990004, "短信验证码错误");

    private ErrorSide errorSide;
    private Subsystem subsystem;
    private Platform platform;
    private int code;
    private String message;

    private SMSErrorCode(ErrorSide errorSide, Subsystem subsystem, Platform platform, int code, String msg) {
        this.errorSide = errorSide;
        this.subsystem = subsystem;
        this.platform = platform;
        this.code = code;
        this.message = msg;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getErrorSide()
     */
    @Override
    public ErrorSide getErrorSide() {
        return errorSide;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getSystem()
     */
    @Override
    public Subsystem getSystem() {
        return subsystem;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getPlatform()
     */
    @Override
    public Platform getPlatform() {
        return platform;
    }

    @Override
    public int getSubsystemErrorCode() {
        return code;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public SMSErrorCode fromCode(int code) {
        for (SMSErrorCode errorCode : values()) {
            if (errorCode.getSubsystemErrorCode() == code) {
                return errorCode;
            }
        }
        return SMSErrorCode.UNKNOW;
    }

}
