
/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.enums;

import com.baijia.tianxiao.dto.UniverseErrorCode;


/**
 * @author zhangbing
 * @version 1.0
 * @title OrgErrorCode
 * @desc TODO
 * @date 2015年12月4日
 */

public enum CrmErrorCode implements UniverseErrorCode {

    UNKNOW(ErrorSide.UNKNOW, Subsystem.UNKNOW, Platform.UNKNOW, 1, "未知类型错误"),

    CONSULTER_NOT_EXISTS(1002, "咨询用户不存在"),

    STUDENT_HAS_EXISTS(1003, "客户已存在"),

    OP_MSG_SWITCH_FAILED(1004, "开启/关闭消息开关失败"),

    CUSTOM_HAS_EXISTS(ErrorSide.SERVER, Subsystem.CONSULT, Platform.PC, 1001, "该客户已存在"),

    NET_WOKR_ERROR(1005, "网络异常"),

    ILLEGAL_REQUEST(1006, "非法请求"),

    GET_CLUE_DETAIL_FAILD(1007, "获取招生线索失败"),

    SAVE_CLUE_INFO_FAILD(1008, "保存招生线索失败"),

    GET_COMMENTS_FAILD(1009, "获取跟进记录失败"),

    GET_STUDENT_FAILD(1010, "获取学员档案失败"),

    UNSUPPORT_QUERY(1011, "不支持的查询请求"),

    SAVE_STUDENT_INFO_FAILD(1012, "保存学员档案失败"),

    GET_CURRENT_CLASS_FAILD(1013, "获取所读班级失败"),

    GET_HISTORY_CLASS_FAILD(1014, "获取报班记录失败"),

    ORG_NOT_EXIST(1015, "机构不存在"),

    FORMAT_ERROR(1016, "格式错误"),

    HANDLER_FAILED(1017, "处理失败"),

    STUDENT_NOT_EXISTS(1018, "机构学员不存在或已被删除"),

    DELETE_STUDENT_FAILD(1019, "删除学员失败"),

    NAME_MUST_BE_HANZI_CHAR(1020, "姓名只允许英文字母、汉字和数字,最多15个字符"),

    MOBILE_FORMAT_ERROR(1021, "手机号码格式不正确"),

    CALL_TIME_OUT(1022, "通话时间已用完"),

    CONSULTER_PULL_BY_OTHER(1023, "无权操作，线索已被他人领取。"),

    CONSULTER_IS_DELETED(1024, "无权操作，线索已被删除。"),

    CONSULTER_PASSTO_FAIL_BY_SETTING_MAX_CLUE_COUNT(1025, "该用户线索数已达上限, 无法转交"),

    CONSULTER_PULL_FAIL_BY_SETTING_MAX_CLUE_COUNT(1026, "线索数已达上限, 无法领取"),

    CONSULTER_PUSH_FAIL_BY_SETTING_RETURN_CLUE(1027, "操作失败, 系统配置不可主动退回线索。"),

    CONSULTER_PUSH_FAIL_BY_SETTING_CLUE_ALLOT(1028, "操作失败, 系统配置员工不可主动领取线索。"),

    ORG_ACCOUNT_TYPE_ERROR(1029, "机构账号类型有误"),

    CONSULTER_ASSIGN_FAIL_BY_SETTING_CLUE_ALLOT(1030, "操作失败, 系统配置不可主动分配线索。"),

    CONSULTER_INFO_NO_PERMISSON(1031, "访问失败, 数据已被转移或删除。"),
    
    EXCEL_TEMPLATE_VALIDATE_FAIL(1032, "模板检测不合法"),

    CONSULTER_INFO_IS_STUDENT(1033, "访问失败, 该线索已转为学员。"),
    

    EXCESS_CAMPUS_COUNT(1050, "校区数已到最大值"),
    EXCESS_CASCADE_ACCOUNT_COUNT(1051, "子帐号数已到最大值"),

    MOBILE_EXIST(1052, "该帐号已经注册为机构，不能被添加"),

    NOT_ONLINE(1061, "访客不在线，无法接收消息"),
    NOT_SUPPORT_CARD(1062, "此类信息对方暂无法接收，现仅可在机构同事间发送"),
    PUBLIC_CLUE(1063, "该访客已被添加为公海线索，非本人线索无法发送消息"),
    WECHAT_TIMEOUT(1064, "访客已48小时未与公众号互动，无法接收信息"),
    NOT_OWNER(1065, "该访客已被添加为线索，非本人线索无法发送消息"),
    NOT_BIND_ORG_WECHAT(1066, "访客未在贵机构公众微信号内进行绑定，无法接收消息"),

    NOT_ALLOW_CLOSE(1071, "您已是最后一名接收新访客的机构人员，无法设置为“不分配”"),

    SOLR_EXCEPTION(1081, "SOLR查询异常"),
    ;

    private ErrorSide errorSide;
    private Subsystem subsystem;
    private Platform platform;
    private int code;
    private String message;

    private CrmErrorCode(ErrorSide errorSide, Subsystem subsystem, Platform platform, int code, String msg) {
        this.errorSide = errorSide;
        this.subsystem = subsystem;
        this.platform = platform;
        this.code = code;
        this.message = msg;
    }

    private CrmErrorCode(int code, String msg) {
        this(ErrorSide.SERVER, Subsystem.ORGANIZATION, Platform.PC, code, msg);
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getErrorSide()
     */
    @Override
    public ErrorSide getErrorSide() {
        return errorSide;
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getSystem()
     */
    @Override
    public Subsystem getSystem() {
        return subsystem;
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getPlatform()
     */
    @Override
    public Platform getPlatform() {
        return platform;
    }

    @Override
    public int getSubsystemErrorCode() {
        return code;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public CrmErrorCode fromCode(int code) {
        for (CrmErrorCode errorCode : values()) {
            if (errorCode.getSubsystemErrorCode() == code) {
                return errorCode;
            }
        }
        return UNKNOW;
    }

    public static void main(String[] args) {
        System.out.println(CONSULTER_INFO_NO_PERMISSON.getSubsystemErrorCode());
        System.out.println(CONSULTER_NOT_EXISTS.code);
    }
}

    