
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.common.service;

import java.util.Map;

/**
 * @title NotifyMsgRenderService
 * @desc 通知消息内容封装接口
 * @author cxm
 * @date 2016年3月18日
 * @version 1.0
 */
public interface WechatMsgRenderService {

    /**
     * 将给定参数进行模板渲染,返回结果
     * 
     * @param msgType 消息类型
     * @param params
     * @return
     * 
     *         params: touser - 接收者的openId url - 点击消息后的跳转地址 可为null first - 模板消息最顶行文字 (文字换行可加\n) remark - 模板消息最尾行文字
     *         keyword1 - 模板消息正文字段 (具体个数 见模板说明 WechateTemplateMsgType.getDemo() ) keyword2 - keyword3 - ....
     */
    public Object render(Integer msgType, Map<String, Object> params);

    /**
     * 发送消息
     * 
     * @param wechatMsg
     * @return
     */
    public boolean sendMsg(Long orgId, Object wechatMsg);
    

    /**
     * 判断一个微信openId是否是指定机构的粉丝
     * 
     * @param orgId
     * @param msgType
     * @param weixinOpenId
     * @return
     */
    //public boolean isOrgFans(Long orgId, Integer msgType, String weixinOpenId);

}
