/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.constants.signup;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum PayType {
    PAY_POS_CARD(0, "POS\u652f\u4ed8"),
    BALANCE(1, "\u4f59\u989d"),
    ALIPAY_POS(2, "\u652f\u4ed8\u5b9d"),
    CASH(4, "\u73b0\u91d1\u652f\u4ed8"),
    PAY_OB(3, "\u7f51\u94f6"),
    PAY_WEI_XIN1(5, "\u5fae\u4fe1"),
    PAY_WEI_XIN2(50, "\u5fae\u4fe1"),
    PAY_CFT(6, "\u8d22\u4ed8\u901a"),
    PAY_KQ_KJ(7, "\u5feb\u94b1\u5feb\u6377\u652f\u4ed8"),
    PAY_YL(8, "\u94f6\u8054\u652f\u4ed8"),
    PAY_YHQ(9, "\u4f18\u60e0\u5238"),
    PAY_ELSE(10, "\u5176\u4ed6\u91d1\u989d"),
    PAY_KJ(11, "\u5feb\u6377\u652f\u4ed8"),
    PAY_KQ(12, "\u5feb\u94b1"),
    TOTAL_BALANCE(21, "\u4f59\u989d\u5168\u91cf\u652f\u4ed8"),
    TOTAL_FAV_CODE(22, "\u5168\u91cf\u4f18\u60e0\u7801\u652f\u4ed8"),
    MIX_BALANCE_FAV(23, "\u6df7\u5408\u4f59\u989d +\u4f18\u60e0\u7801\u652f\u4ed8"),
    PAY_KQ_OB(24, "\u5feb\u94b1\u7f51\u94f6\u652f\u4ed8"),
    BAIDU_PAY(25, "BAIDU_PAY"),
    PAY_BDZD(26, "\u767e\u5ea6\u76f4\u8fbe\u53f7\u652f\u4ed8"),
    PAY_POS_YINLIAN_CARD(27, "\u94f6\u8054POS\u652f\u4ed8"),
    PAY_POS_KUAIQIAN_CARD(28, "\u5feb\u94b1POS\u652f\u4ed8"),
    WX_POS(30, "\u5fae\u4fe1\u626b\u7801\u652f\u4ed8"),
    APPSTORE_PAY(32, "\u82f9\u679c\u652f\u4ed8"),
    STUDYCOIN_PAY(33, "\u82f9\u679c\u6e20\u9053\u5b66\u5e01\u652f\u4ed8"),
    LKL_POS(40, "\u62c9\u5361\u62c9POS\u673a\u652f\u4ed8"),
    ONLINE_PAYMENT(51, "\u5728\u7ebf\u652f\u4ed8");

    private int code;
    private String note;
    private static Map<Integer, PayType> map;

    private PayType(int code, String note) {
        this.code = code;
        this.note = note;
    }

    public static List<Integer> getAllCode() {
        return new ArrayList<Integer>(map.keySet());
    }

    public int getCode() {
        return this.code;
    }

    public String getNote() {
        return this.note;
    }

    public static PayType getPayTypeByCode(Integer code) {
        return map.get(code);
    }

    public static PayType getPayTypeByTypeStr(String payTypeStr) {
        if (StringUtils.isBlank((CharSequence)payTypeStr)) {
            return ONLINE_PAYMENT;
        }
        try {
            int tempPayType = Integer.parseInt(payTypeStr);
            PayType payType = PayType.getPayTypeByCode(tempPayType);
            if (payType == null) {
                return ONLINE_PAYMENT;
            }
            return payType;
        }
        catch (Exception e) {
            String[] payTypes = payTypeStr.split("_");
            String[] payTypeDetailStr = payTypes[0].split(":");
            if (payTypeDetailStr.length != 2) {
                return ONLINE_PAYMENT;
            }
            Integer typeValue = Integer.parseInt(payTypeDetailStr[0]);
            if (typeValue == 4) {
                return PAY_WEI_XIN2;
            }
            PayType payType = PayType.getPayTypeByCode(typeValue);
            if (payType == null) {
                return ONLINE_PAYMENT;
            }
            return payType;
        }
    }

    public static String getNameByPayType(String payTypeStr) {
        PayType result = PayType.getPayTypeByTypeStr(payTypeStr);
        if (result == PAY_POS_YINLIAN_CARD || result == PAY_POS_KUAIQIAN_CARD) {
            return PAY_POS_CARD.getNote();
        }
        if (result != PAY_POS_CARD && result != CASH) {
            return ONLINE_PAYMENT.getNote();
        }
        return result.getNote();
    }

    public static int getCodeByPayType(String payTypeStr) {
        PayType result = PayType.getPayTypeByTypeStr(payTypeStr);
        if (result == PAY_POS_YINLIAN_CARD || result == PAY_POS_KUAIQIAN_CARD) {
            return PAY_POS_CARD.getCode();
        }
        if (result != PAY_POS_CARD && result != CASH) {
            return ONLINE_PAYMENT.getCode();
        }
        return result.getCode();
    }

    public static int getCodeByPayType(int payTypeCode) {
        PayType result = PayType.getPayTypeByCode(payTypeCode);
        if (result == PAY_POS_YINLIAN_CARD || result == PAY_POS_KUAIQIAN_CARD) {
            return PAY_POS_CARD.getCode();
        }
        if (result != PAY_POS_CARD && result != CASH) {
            return ONLINE_PAYMENT.getCode();
        }
        return result.getCode();
    }

    public static String getByCode(int code) {
        int payCode = PayType.getCodeByPayType(code);
        return PayType.getPayTypeByCode(payCode).getNote();
    }

    static {
        map = Maps.newHashMap();
        for (PayType payType : PayType.values()) {
            map.put(payType.code, payType);
        }
    }
}

