/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SplitMergeUtils {
    public static int BATCH_SIZE = 500;

    public static <T> List<List<T>> splitList(List<T> orig, int batchSize) {
        if (orig == null || orig.isEmpty() || batchSize < 1) {
            return Arrays.asList(orig);
        }
        int size = orig.size();
        int len = SplitMergeUtils.calSplitLen(batchSize, size);
        ArrayList<List<T>> result = new ArrayList<List<T>>(len);
        for (int i = 0; i < len; ++i) {
            result.add(orig.subList(i * batchSize, (i + 1) * batchSize < size ? (i + 1) * batchSize : size));
        }
        return result;
    }

    public static <T> List<T> merge(List<List<T>> splits) {
        if (splits != null && splits.size() > 0) {
            ArrayList<T> list = new ArrayList<T>();
            for (List<T> split : splits) {
                list.addAll(split);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public static <T> Set<Set<T>> splitSet(Set<T> orig, int batchSize) {
        if (orig == null || orig.isEmpty() || batchSize < 1) {
            return new HashSet<Set<T>>(Arrays.asList(orig));
        }
        int size = orig.size();
        int len = SplitMergeUtils.calSplitLen(batchSize, size);
        HashSet<Set<T>> result = new HashSet<Set<T>>(len);
        ArrayList<T> list = new ArrayList<T>(orig);
        for (int i = 0; i < len; ++i) {
            result.add(new HashSet(list.subList(i * batchSize, (i + 1) * batchSize < size ? (i + 1) * batchSize : size)));
        }
        return result;
    }

    public static <T> Set<T> merge(Set<Set<T>> splits) {
        if (splits != null && splits.size() > 0) {
            HashSet<T> list = new HashSet<T>();
            for (Set<T> split : splits) {
                list.addAll(split);
            }
            return list;
        }
        return Collections.emptySet();
    }

    public static <T> Collection<Collection<T>> splitCollection(Collection<T> orig, int batchSize) {
        if (orig == null || orig.isEmpty() || batchSize < 1) {
            HashSet<Collection<T>> result = new HashSet<Collection<T>>();
            result.add(new HashSet<T>(orig));
            return result;
        }
        int size = orig.size();
        int len = SplitMergeUtils.calSplitLen(batchSize, size);
        HashSet<Collection<T>> result = new HashSet<Collection<T>>(len);
        ArrayList<T> list = null;
        list = orig instanceof List ? (ArrayList<T>)orig : new ArrayList<T>(orig);
        for (int i = 0; i < len; ++i) {
            result.add(new HashSet(list.subList(i * batchSize, (i + 1) * batchSize < size ? (i + 1) * batchSize : size)));
        }
        return result;
    }

    private static int calSplitLen(int batchSize, int size) {
        return (size - 1) / batchSize + 1;
    }

    public static <T> List<List<T>> splitList(List<T> orig) {
        return SplitMergeUtils.splitList(orig, BATCH_SIZE);
    }

    public static <T> Set<Set<T>> splitSet(Set<T> orig) {
        return SplitMergeUtils.splitSet(orig, BATCH_SIZE);
    }

    public static <T> Collection<Collection<T>> splitCollection(Collection<T> orig) {
        return SplitMergeUtils.splitCollection(orig, BATCH_SIZE);
    }
}

