/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.pay;

import com.baijia.commons.lang.utils.PropertiesReader;
import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayHttpRestUtil {
    private static final Logger log = LoggerFactory.getLogger(PayHttpRestUtil.class);
    public static final String PAY_SERVICE;
    public static final String API_PAY_RUL;

    public static Object rest(String url, Map<String, String> params) throws BussinessException {
        RestfulResult restfulResult = null;
        try {
            log.info("payHttpRestUtil params== {}", params);
            String resultJson = HttpClientUtils.doPost(url, params);
            log.info("payHttpRestUtil result={}", (Object)resultJson);
            restfulResult = JacksonUtil.str2Obj(resultJson, RestfulResult.class);
            if (restfulResult.getCode() != 0) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, restfulResult.getMsg());
            }
        }
        catch (Exception e) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, restfulResult.getMsg());
        }
        return restfulResult.getData();
    }

    static {
        Properties prop = PropertiesReader.fillProperties((String)"rest.properties");
        PAY_SERVICE = prop.getProperty("rest.appServiceUrl.new");
        API_PAY_RUL = PAY_SERVICE + "/pay/api";
    }
}

