/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util;

import com.baijia.tianxiao.util.memcached.MemcachedUtil;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.exception.MemcachedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyCodeUtil {
    public static final Logger logger = LoggerFactory.getLogger(VerifyCodeUtil.class);
    public static final int CODE_EXP_TIME = 1800;
    public static final int CODE_INTERVAL_TIME = 60;
    public static final String TX_SMS_APP_PREFIX = "tx_sms_prefix_app_";
    public static final String TX_SMS_PC_PREFIX = "tx_sms_prefix_pc_";

    public static String getFromMemCache(String key) {
        String code = null;
        try {
            code = (String)MemcachedUtil.get(key);
        }
        catch (InterruptedException | TimeoutException | MemcachedException e) {
            logger.error("read code from memcached error:{}", e);
        }
        logger.info("read code:{} from memcached by key:{}", (Object)code, (Object)key);
        return code;
    }

    public static String newCode() {
        StringBuilder builder = new StringBuilder();
        for (int count = 4; count > 0; --count) {
            builder.append(new Random().nextInt(10));
        }
        return builder.toString();
    }

    public static String newCodeAndCached(boolean isApp, String mobile, String key) {
        String code = VerifyCodeUtil.newCode();
        try {
            MemcachedUtil.set(VerifyCodeUtil.getCacheKey(isApp, mobile, key), 1800, code);
            MemcachedUtil.set(VerifyCodeUtil.getIntervalKey(isApp, mobile, key), 60, code);
        }
        catch (InterruptedException | TimeoutException | MemcachedException e) {
            logger.error("save code to memcached error:{}", e);
            return null;
        }
        logger.info("new code:{} succeed, cache key:{}", (Object)code, (Object)VerifyCodeUtil.getCacheKey(isApp, mobile, key));
        return code;
    }

    public static boolean hasSended(boolean isApp, String mobile, String key) {
        return null != VerifyCodeUtil.getFromMemCache(VerifyCodeUtil.getIntervalKey(isApp, mobile, key));
    }

    public static boolean valid(boolean isApp, String mobile, String code, String key) {
        String cachedCode = VerifyCodeUtil.getFromMemCache(VerifyCodeUtil.getCacheKey(isApp, mobile, key));
        logger.info("valid verify code expect:{},actual:{}", (Object)cachedCode, (Object)code);
        return code.equals(cachedCode);
    }

    private static String getCacheKey(boolean isApp, String mobile, String key) {
        if (isApp) {
            return TX_SMS_APP_PREFIX + key + "_VERIFY_CODE_" + mobile;
        }
        return TX_SMS_PC_PREFIX + key + "_VERIFY_CODE_" + mobile;
    }

    private static String getIntervalKey(boolean isApp, String mobile, String key) {
        if (isApp) {
            return TX_SMS_APP_PREFIX + key + "_VERIFY_CODE_INTERVAL_KEY_" + mobile;
        }
        return TX_SMS_PC_PREFIX + key + "_VERIFY_CODE_INTERVAL_KEY_" + mobile;
    }
}

