/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.excel;

import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import lombok.NonNull;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.locale.converters.DateLocaleConverter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExporterUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelExporterUtils.class);
    private static final String EXPORT_CELL_STYLS = "export_cell_styls_";
    private static final Logger logger = LoggerFactory.getLogger(ExcelExporterUtils.class);
    public static final String EXPORT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();

    public static List<Object[]> read(File file, int sheetNum) {
        List<Object[]> list;
        Closeable wb = null;
        PushbackInputStream in = null;
        try {
            in = new PushbackInputStream(new FileInputStream(file), 8);
            list = ExcelExporterUtils.read(in, sheetNum);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("read excel exception - ", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(wb);
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(wb);
        IOUtils.closeQuietly((InputStream)in);
        return list;
    }

    public static List<Object[]> read(@NonNull InputStream in, int sheetNum) {
        List<Object[]> list;
        if (in == null) {
            throw new NullPointerException("in");
        }
        Object wb = null;
        try {
            if (!(in instanceof PushbackInputStream)) {
                in = new PushbackInputStream(in, 8);
            }
            wb = POIFSFileSystem.hasPOIFSHeader((InputStream)in) ? new HSSFWorkbook(in) : new XSSFWorkbook(in);
            Sheet sheet = wb.getSheetAt(sheetNum);
            list = ExcelExporterUtils.getTable(sheet);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("read excel exception - ", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(wb);
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)wb);
        IOUtils.closeQuietly((InputStream)in);
        return list;
    }

    private static List<Object[]> getTable(Sheet sheet) {
        logger.trace("sheet:{}, firstRowNum:{}, lastRowNum:{}", new Object[]{sheet.getSheetName(), sheet.getFirstRowNum(), sheet.getLastRowNum()});
        ArrayList<Object[]> list = new ArrayList<Object[]>(sheet.getLastRowNum() + 1);
        int columnCount = 0;
        for (int r = sheet.getFirstRowNum(); r <= sheet.getLastRowNum(); ++r) {
            Row row = sheet.getRow(r);
            if (row == null) {
                logger.trace("row:{}, null", (Object)r);
                continue;
            }
            logger.trace("row:{}, firstCellNum:{}, lastCellNum:{}", new Object[]{row.getRowNum(), row.getFirstCellNum(), row.getLastCellNum()});
            if (row.getLastCellNum() <= 0) continue;
            if (columnCount == 0) {
                columnCount = row.getLastCellNum();
            }
            Object[] rowObj = new Object[columnCount];
            boolean hasValueRow = false;
            for (int c = row.getFirstCellNum(); c < row.getLastCellNum(); ++c) {
                Cell cell = row.getCell(c);
                logger.trace("row:{}, cell:{}, value:{}", new Object[]{row.getRowNum(), c, cell});
                rowObj[c] = ExcelExporterUtils.getValueFromCell(cell);
                if (hasValueRow || rowObj[c] == null || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rowObj[c].toString()})) continue;
                hasValueRow = true;
            }
            if (!hasValueRow) continue;
            list.add(rowObj);
        }
        return list;
    }

    public static final Object getValueFromCell(Cell cell) {
        if (cell == null) {
            return "";
        }
        Object value = null;
        switch (cell.getCellType()) {
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    value = cell.getDateCellValue();
                    break;
                }
                String cellFormat = cell.getCellStyle().getDataFormatString();
                value = cell.getNumericCellValue();
                if (!"General".equals(cellFormat) && !"@".equals(cellFormat)) break;
                cellFormat = "0";
                DecimalFormat format = new DecimalFormat(cellFormat);
                value = format.format(cell.getNumericCellValue());
                break;
            }
            case 1: {
                value = cell.getStringCellValue();
                break;
            }
            case 2: {
                double numericValue = cell.getNumericCellValue();
                if (DateUtil.isValidExcelDate((double)numericValue)) {
                    value = cell.getDateCellValue();
                    break;
                }
                value = String.valueOf(numericValue);
                break;
            }
            case 3: {
                value = "";
                break;
            }
            case 4: {
                value = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 5: {
                value = String.valueOf(cell.getErrorCellValue());
                break;
            }
            default: {
                value = "";
            }
        }
        return value;
    }

    public static <T> void exportToExcel(HttpServletResponse response, List<T> data, String[] fields, String[] fieldValue) {
        ExcelExporterUtils.exportToExcel(response, data, fields, fieldValue, null);
    }

    public static <T> void exportToExcel(HttpServletResponse response, List<T> data, String[] fields, String[] fieldValue, String fileName) {
        if (fileName == null || "".equals(fileName)) {
            fileName = System.currentTimeMillis() + ".xlsx";
        }
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "utf-8"));
        }
        catch (UnsupportedEncodingException e1) {
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
        }
        try {
            ExcelExporterUtils.exportToExcel((OutputStream)response.getOutputStream(), data, fields, fieldValue);
        }
        catch (IOException e) {
            throw new RuntimeException("export data error", e);
        }
    }

    public static <T> ZipOutputStream getZipOutputStream(HttpServletResponse response, String fileName) throws IOException {
        if (fileName == null || "".equals(fileName)) {
            fileName = System.currentTimeMillis() + ".zip";
        }
        response.setContentType("application/zip");
        response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "utf-8"));
        ConvertUtils.register((Converter)new DateLocaleConverter(Locale.CHINA), Date.class);
        ZipOutputStream out = new ZipOutputStream((OutputStream)response.getOutputStream());
        return out;
    }

    public static <T> void exportToZip(ZipOutputStream out, List<T> data, String[] fields, String[] fieldValue, String fileName) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ExcelExporterUtils.exportToExcel((OutputStream)baos, data, fields, fieldValue);
            out.putNextEntry(new ZipEntry("./tianxiao_export/" + fileName + ".xlsx"));
            out.write(baos.toByteArray());
            out.flush();
            out.closeEntry();
        }
        catch (IOException e) {
            throw new RuntimeException("export data error", e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)baos);
        }
    }

    public static <T> void closeZipOutputStream(ZipOutputStream out) {
        if (out != null) {
            try {
                out.flush();
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static CellStyle createCellStyle(Workbook workBook, String format, Map<String, CellStyle> cellStyleMap) {
        String key = EXPORT_CELL_STYLS + format;
        CellStyle cellStyle = cellStyleMap.get(key);
        if (cellStyle == null) {
            DataFormat dataFormat = workBook.createDataFormat();
            cellStyle = workBook.createCellStyle();
            cellStyle.setAlignment((short)2);
            cellStyle.setDataFormat(dataFormat.getFormat(format));
            cellStyleMap.put(key, cellStyle);
        }
        return cellStyle;
    }

    private static void createCell(Sheet sheet, Row row, int column, Object value, Map<String, CellStyle> cellStyleMap) {
        Cell cell = row.createCell(column);
        if (value != null) {
            String format = null;
            if (value instanceof Date) {
                sheet.setColumnWidth(cell.getColumnIndex(), 5120);
                format = EXPORT_DATE_FORMAT;
                cell.setCellValue((Date)value);
            } else if (value instanceof Number && ((Number)value).longValue() < Integer.MAX_VALUE) {
                cell.setCellType(0);
                if (value instanceof Double) {
                    format = "0.00";
                    cell.setCellValue(((Number)value).doubleValue());
                } else {
                    format = "0";
                    cell.setCellValue((double)((Number)value).longValue());
                }
            } else {
                cell.setCellType(1);
                cell.setCellValue(value.toString());
                format = "@";
            }
            if (format != null) {
                cell.setCellStyle(ExcelExporterUtils.createCellStyle(sheet.getWorkbook(), format, cellStyleMap));
            }
        } else {
            cell.setCellValue("");
        }
    }

    public static <T> void exportToExcel(OutputStream os, List<T> data, String[] fields, String[] fieldValue) {
        if (fields == null || fieldValue == null) {
            throw new RuntimeException("fields or header can't be null.");
        }
        XSSFWorkbook wb = new XSSFWorkbook();
        Sheet sheet = wb.createSheet("ExportDataList");
        Row headerTitle = sheet.createRow(0);
        int index = 0;
        for (int i = 0; i < fields.length; ++i) {
            Cell cell = headerTitle.createCell(index++ % fields.length);
            cell.setCellValue(fieldValue[i]);
            sheet.setColumnWidth(cell.getColumnIndex(), fieldValue[i].length() * 8 * 256);
            cell.getCellStyle().setAlignment((short)2);
        }
        logger.debug("exportToExcel data size={}", (Object)data.size());
        try {
            HashMap cellStyleMap = Maps.newHashMap();
            for (int i = 0; i < data.size(); ++i) {
                Row row = sheet.createRow(i + 1);
                T o = data.get(i);
                for (int j = 0; j < fields.length; ++j) {
                    try {
                        ExcelExporterUtils.createCell(sheet, row, index++ % fields.length, propertyUtilsBean.getProperty(o, fields[j]), cellStyleMap);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException("export data error", e);
                    }
                }
            }
            wb.write(os);
            os.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("export data error", e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)wb);
        }
    }

    public static void fillSheet(Sheet sheet, List<String> headers, Collection<Object[]> datas, Map<String, CellStyle> cellStyleMap) {
        int i;
        Row headerTitle = sheet.createRow(0);
        int index = 0;
        for (i = 0; i < headers.size(); ++i) {
            String name = headers.get(i);
            int column = index++ % headers.size();
            sheet.setColumnWidth(column, name.length() * 2 * 256);
            Cell cell = headerTitle.createCell(column);
            cell.setCellValue(name);
            cell.getCellStyle().setAlignment((short)2);
        }
        i = 0;
        if (cellStyleMap == null) {
            cellStyleMap = Maps.newHashMap();
        }
        for (Object[] o : datas) {
            Row row = sheet.createRow(i + 1);
            for (int j = 0; j < o.length; ++j) {
                try {
                    ExcelExporterUtils.createCell(sheet, row, index++ % o.length, o[j], cellStyleMap);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("export data error", e);
                }
            }
            ++i;
        }
    }

    public static <T> void fillSheet(Sheet sheet, Collection<T> data, String[] fields, String[] fieldValue, Map<String, CellStyle> cellStyleMap) {
        int i;
        Row headerTitle = sheet.createRow(0);
        int index = 0;
        for (i = 0; i < fields.length; ++i) {
            int column = index++ % fields.length;
            sheet.setColumnWidth(column, fieldValue[i].length() * 2 * 256);
            Cell cell = headerTitle.createCell(column);
            cell.setCellValue(fieldValue[i]);
            cell.getCellStyle().setAlignment((short)2);
        }
        i = 0;
        if (cellStyleMap == null) {
            cellStyleMap = Maps.newHashMap();
        }
        for (T o : data) {
            Row row = sheet.createRow(i + 1);
            for (int j = 0; j < fields.length; ++j) {
                try {
                    ExcelExporterUtils.createCell(sheet, row, index++ % fields.length, propertyUtilsBean.getProperty(o, fields[j]), cellStyleMap);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("export data error", e);
                }
            }
            ++i;
        }
    }
}

