/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dto.query;

import com.baijia.tianxiao.annotation.Option;
import com.baijia.tianxiao.annotation.Snippet;
import com.baijia.tianxiao.dto.query.AutoMatchQueryRequest;
import com.baijia.tianxiao.enums.SortPolicy;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class CommonSearchRequestDto {
    private int orderType = 0;
    private String name;
    private String orderName;
    private String query;
    private Long start;
    private Long end;
    private int pageNum;
    private int pageSize;
    private int status;

    public PageDto getPageDto() {
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(Integer.valueOf(this.pageNum));
        pageDto.setPageSize(Integer.valueOf(this.pageSize));
        return pageDto;
    }

    public AutoMatchQueryRequest generateAutoMatchModel(Class<?> clazz) {
        AutoMatchQueryRequest model = new AutoMatchQueryRequest();
        if (StringUtils.isBlank((CharSequence)this.name) && StringUtils.isBlank((CharSequence)this.query) && StringUtils.isBlank((CharSequence)this.orderName)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)this.orderName)) {
            model.setSortPolicy(this.orderType == 0 ? SortPolicy.ASC : SortPolicy.DESC);
            model.setOrderName(this.orderName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.name) && !this.name.equals("tag")) {
            Option option = Snippet.getAnnotation(clazz, this.name);
            if (option != null) {
                model.setQueryPolicy(option.policy());
                model.setPropName(option.name());
            }
            if (StringUtils.isBlank((CharSequence)this.query)) {
                return model;
            }
            switch (option.type()) {
                case STRING: {
                    model.setValue(this.query);
                    break;
                }
                case DIGITAL: {
                    model.setValue(this.query);
                    break;
                }
                case DATE: {
                    model.setStart(new Date(this.start));
                    model.setEnd(new Date(this.end));
                    break;
                }
            }
        }
        return model;
    }

    public int getOrderType() {
        return this.orderType;
    }

    public String getName() {
        return this.name;
    }

    public String getOrderName() {
        return this.orderName;
    }

    public String getQuery() {
        return this.query;
    }

    public Long getStart() {
        return this.start;
    }

    public Long getEnd() {
        return this.end;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getStatus() {
        return this.status;
    }

    public void setOrderType(int orderType) {
        this.orderType = orderType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOrderName(String orderName) {
        this.orderName = orderName;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public void setEnd(Long end) {
        this.end = end;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonSearchRequestDto)) {
            return false;
        }
        CommonSearchRequestDto other = (CommonSearchRequestDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOrderType() != other.getOrderType()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$orderName = this.getOrderName();
        String other$orderName = other.getOrderName();
        if (this$orderName == null ? other$orderName != null : !this$orderName.equals(other$orderName)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        Long this$start = this.getStart();
        Long other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        Long this$end = this.getEnd();
        Long other$end = other.getEnd();
        if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
            return false;
        }
        if (this.getPageNum() != other.getPageNum()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        return this.getStatus() == other.getStatus();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonSearchRequestDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOrderType();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $orderName = this.getOrderName();
        result = result * 59 + ($orderName == null ? 43 : $orderName.hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        Long $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        Long $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        result = result * 59 + this.getPageNum();
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getStatus();
        return result;
    }

    public String toString() {
        return "CommonSearchRequestDto(orderType=" + this.getOrderType() + ", name=" + this.getName() + ", orderName=" + this.getOrderName() + ", query=" + this.getQuery() + ", start=" + this.getStart() + ", end=" + this.getEnd() + ", pageNum=" + this.getPageNum() + ", pageSize=" + this.getPageSize() + ", status=" + this.getStatus() + ")";
    }
}

