/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class DateUtil {
    private DateUtil() {
    }

    public static Date getMinUnixDate() {
        return new Date(0L);
    }

    public static long currentUnixTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long date2UnixTimestamp(Date date) {
        return date.getTime() / 1000L;
    }

    public static Date UnixTimestamp2Date(long timestamp) {
        return new Date(timestamp * 1000L);
    }

    public static Date getCurrentDate() {
        Calendar today = Calendar.getInstance();
        today.set(today.get(1), today.get(2), today.get(5), 0, 0, 0);
        Date date = new Date();
        date.setTime(today.getTimeInMillis() / 1000L * 1000L);
        return date;
    }

    public static Date getFirstDate(Date date) {
        Calendar today = Calendar.getInstance();
        today.setTime(date);
        today.set(today.get(1), today.get(2), 1, 0, 0, 0);
        date.setTime(today.getTimeInMillis() / 1000L * 1000L);
        return date;
    }

    public static Date getNextMonthFirstDate(Date date) {
        Calendar today = Calendar.getInstance();
        today.setTime(date);
        today.set(today.get(1), today.get(2) + 1, 1, 0, 0, 0);
        date.setTime(today.getTimeInMillis() / 1000L * 1000L);
        return date;
    }

    public static Date getLastHourDate() {
        Calendar today = Calendar.getInstance();
        today.set(10, today.get(10) - 1);
        return today.getTime();
    }

    public static Date getDiffDateTime(Date date, int diff) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, diff);
        return calendar.getTime();
    }

    public static boolean whetherInTheAm(Date date) {
        GregorianCalendar ca = new GregorianCalendar();
        ca.setTime(date);
        return ca.get(9) == 0;
    }

    public static boolean isToday(Date date) {
        Calendar today = Calendar.getInstance();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return today.get(1) == calendar.get(1) && today.get(2) == calendar.get(2) && today.get(5) == calendar.get(5);
    }

    public static int getThisYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(1);
    }

    public static int getThisMonth() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1;
    }

    public static String getDayStr(Date date) {
        return DateUtil.getStrByDateFormate(date, "yyyMMdd");
    }

    public static String getHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return String.valueOf(calendar.get(11));
    }

    public static Date getDateByYearMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, 1);
        return calendar.getTime();
    }

    public static int getMonthDiff(Date date1, Date date2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(date1);
        c2.setTime(date2);
        return (c2.get(1) - c1.get(1)) * 12 + (c2.get(2) - c1.get(2));
    }

    public static Date getStrToDate(String format, String str) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        simpleDateFormat.applyPattern(format);
        try {
            return simpleDateFormat.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getDateByStr(String date) {
        return DateUtil.getStrToDate("yyyy-MM-dd", date);
    }

    public static String getStrByDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateformat1 = new SimpleDateFormat("yyyy-MM-dd");
        String str = dateformat1.format(date);
        return str;
    }

    public static String getStrByDateFormate(Date date, String formate) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateformat1 = new SimpleDateFormat(formate);
        String str = dateformat1.format(date);
        return str;
    }

    public static Date getOffSetDate(Date date, int offSet) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(5, offSet);
        return cal.getTime();
    }

    public static Date getOffSetDate(int offSet) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, offSet);
        return cal.getTime();
    }

    public static int dateCompare(Date startDate, Date endDate) {
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        start.setTime(startDate);
        end.setTime(endDate);
        start.set(start.get(1), start.get(2), start.get(5), 0, 0, 0);
        end.set(end.get(1), end.get(2), end.get(5), 0, 0, 0);
        long startTime = start.getTimeInMillis() / 1000L;
        long endTime = end.getTimeInMillis() / 1000L;
        if (startTime < endTime) {
            return 1;
        }
        if (startTime > endTime) {
            return -1;
        }
        return 0;
    }

    public static List<Date> getDateBetween(Date startDate, Date endDate) {
        Date date;
        ArrayList<Date> dates = new ArrayList<Date>();
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        start.setTime(startDate);
        end.setTime(endDate);
        start.set(start.get(1), start.get(2), start.get(5), 0, 0, 0);
        end.set(end.get(1), end.get(2), end.get(5), 0, 0, 0);
        Calendar current = start;
        while (DateUtil.dateCompare(current.getTime(), end.getTime()) > 0) {
            date = new Date();
            date.setTime(current.getTimeInMillis() / 1000L * 1000L);
            dates.add(date);
            current.add(5, 1);
        }
        date = new Date();
        date.setTime(current.getTimeInMillis() / 1000L * 1000L);
        dates.add(date);
        current.add(5, 1);
        return dates;
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.getLastHourDate());
        System.out.println(DateUtil.getLastHourDate());
        Calendar calendar = Calendar.getInstance();
        Date date = new Date();
        calendar.setTime(date);
        calendar.set(2014, 1, 2, 0, 2);
        System.out.println(calendar.getTime());
        calendar.set(10, calendar.get(10) - 1);
        System.out.println(calendar.getTime());
        System.out.println(DateUtil.getLastHourDate());
        System.out.println(new Date().getTime());
        System.out.println(DateUtil.getFirstDate(date));
        System.out.println(DateUtil.getNextMonthFirstDate(date));
        System.out.println(DateUtil.getMonthDiff(new Date(), DateUtil.getDateByYearMonth(2015, 1)));
    }
}

