/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util;

import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.util.http.GSXService;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import com.google.common.base.Preconditions;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsSendUtil {
    private static final Logger log = LoggerFactory.getLogger(SmsSendUtil.class);

    public static boolean sendSms(String mobile, String content, Integer messageType, Integer userId, Integer userRole, boolean directSend) {
        try {
            String controller = "sms";
            String action = "send";
            TreeMap<String, String> params = new TreeMap<String, String>();
            params.put("mobile", mobile.replaceAll(" ", "").replace("-", ""));
            Preconditions.checkArgument((boolean)ParamValidateUtils.validateMobile((String)params.get("mobile")), (Object)("mobile :" + mobile + " is invalidate."));
            params.put("content", content);
            params.put("message_type", String.valueOf(messageType));
            if (userId != null) {
                params.put("user_id", String.valueOf(userId));
            }
            if (userRole != null) {
                params.put("role", String.valueOf(userRole));
            }
            if (directSend) {
                params.put("direct_send", "1");
            }
            log.info("send sms to mobile:{},params:{}", (Object)mobile, params);
            RestfulResult response = GSXService.doService(controller, action, params);
            if (response == null) {
                return false;
            }
            return response.getCode() == 0;
        }
        catch (Exception e) {
            log.error("sendSms exception - ", (Throwable)e);
            return false;
        }
    }

    public static boolean sendSms(String mobile, String content, Integer messageType, Integer userId, Integer userRole) {
        return SmsSendUtil.sendSms(mobile, content, messageType, userId, userRole, false);
    }
}

