/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.task;

import lombok.extern.slf4j.Slf4j;

import com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncStatus;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.api.FansService;

/**   
 * @title       : FansSyncJob 
 * @description : 更新微信粉丝
 * @author      : zhenyujian
 * @date        : 2015年12月9日 上午12:51:54 
 */
@Slf4j
public class FansSyncJob implements Runnable{
	
	private FansService fansService;
	private AuthorizerInfoService authorizerInfoService;
	private String authorizerAppId;
	
	public FansSyncJob(FansService fansService, String authorizerAppId, AuthorizerInfoService authorizerInfoService){
		this.fansService = fansService;
		this.authorizerInfoService = authorizerInfoService;
		this.authorizerAppId = authorizerAppId;
	}

	
	@Override
	public void run() {
		log.info("Wechat - FansSyncJob - run - start - authorizerAppId:{}",authorizerAppId);
		AuthorizerInfo authorizerInfo = authorizerInfoService.getByAuthorizerAppId(authorizerAppId);
		
		if(authorizerInfo.getFansSyncStatus().intValue() == WechatDataSyncStatus.ONGOING.getValue()){
			return;
		}
		
		authorizerInfo.setFansSyncStatus( WechatDataSyncStatus.ONGOING.getValue() );
		authorizerInfoService.update(authorizerInfo);
		
		try{
			fansService.syncFans(authorizerAppId);
			Thread.currentThread().sleep(5000);//避免主从延迟
			fansService.batchConvertFansHeadImg(authorizerAppId);
		}catch(WechatException e){
			log.error("Wechat - FansSyncJob - WechatException - e:{}",e);
		}catch(Exception e){
			log.error("Wechat - FansSyncJob - Exception - e:{}",e);
		}finally{
			authorizerInfo.setFansSyncStatus( WechatDataSyncStatus.END.getValue() );
			authorizerInfoService.update(authorizerInfo);
		}
		log.info("Wechat - FansSyncJob - run - end authorizerAppId:{}",authorizerAppId);
		
		//TaskHelper.getInstance().addTask(new FansSyncJob(this, authorizerInfo.getAuthorizerAppId(), authorizerInfoService));
	}

}

