/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import java.util.ArrayList;
import java.util.List;

import lombok.extern.slf4j.Slf4j;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.wechat.constant.WechatOpenIdEntityType;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatOpenIdRecordDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatOpenIdRecord;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.api.FreeVersionService;
import com.baijia.tianxiao.sal.wechat.api.WechatOpenIdRecordService;

@Slf4j
@Service
public class WechatOpenIdRecordServiceImpl implements WechatOpenIdRecordService{
	
	@Autowired
	private OrgWechatOpenIdRecordDao wechatOpenIdRecordDao;
	@Autowired
	private FreeVersionService freeVersionService;
	@Autowired
	private AuthorizerInfoService authorizerInfoService;
	@Autowired
	private FansDao fansDao;

	@Override
	public List<Long> listOrgIdBy(String wechatAppId, String openId, WechatOpenIdEntityType entityType) {
		List<Long> orgIdlist = new ArrayList<Long>();

		if(freeVersionService.isFreeAccount(wechatAppId)){
			List<OrgWechatOpenIdRecord> list = wechatOpenIdRecordDao.listBy(wechatAppId, openId, entityType);
			if(CollectionUtils.isNotEmpty(list)){
				for(OrgWechatOpenIdRecord record:list){
					if(freeVersionService.isFreeAccountOrUnBindWechatApp(record.getOrgId().intValue())){
						orgIdlist.add(record.getOrgId());
					}
				}
			}
		}else{
			AuthorizerInfo authorizerInfo = authorizerInfoService.getByAuthorizerAppId(wechatAppId);
			if(authorizerInfo!=null){
				Fans fans = fansDao.getByOpenId(openId);
				if(fans!=null && fans.getAuthorizerAppId().equals(authorizerInfo.getAuthorizerAppId())){
					orgIdlist.add(authorizerInfo.getOrgId().longValue());
				}
			}
		}
		
		
		return orgIdlist;
	}

	@Override
	public Long getStudentIdBy(String wechatAppId, Long orgId, String openId) {
		List<OrgWechatOpenIdRecord> records = wechatOpenIdRecordDao.listBy(wechatAppId, orgId, openId, WechatOpenIdEntityType.STUDENT);
		if(CollectionUtils.isNotEmpty(records)){
			OrgWechatOpenIdRecord record = records.get(0);
			if(freeVersionService.isFreeAccount(wechatAppId)){
				if(freeVersionService.isFreeAccountOrUnBindWechatApp(record.getOrgId().intValue())){
					return record.getEntityId();
				}else{
					return null;
				}
			}
			return record.getEntityId();
		}
		return null;
	}

	
	@Override
	public void saveOrUpdateByUniqueKey(OrgWechatOpenIdRecord record) {
		WechatOpenIdEntityType type = WechatOpenIdEntityType.getByValue(record.getEntityType());
		OrgWechatOpenIdRecord dbRecord = wechatOpenIdRecordDao.getBy(record.getAuthorizerAppId(), record.getOrgId(), record.getEntityId(), type);
		if(dbRecord != null){
			record.setId(dbRecord.getId());
			record.setCreateTime(dbRecord.getCreateTime());
		}
		
		try{
			wechatOpenIdRecordDao.saveOrUpdate(record);
        }catch(Exception e){
        	try{
	        	dbRecord = wechatOpenIdRecordDao.getBy(record.getAuthorizerAppId(), record.getOrgId(), record.getEntityId(), type);
	    		if(dbRecord != null){
	    			record.setId(dbRecord.getId());
	    			record.setCreateTime(dbRecord.getCreateTime());
	    		}
        	 }catch(Exception e1){
        		 log.warn("saveOrUpdateByUniqueKey - error - record:{}, e:{}",record, e1);
        	 }
        }
	}

	@Override
	public List<OrgWechatOpenIdRecord> listBy(Long orgId, String openId, WechatOpenIdEntityType entityType) {
		return wechatOpenIdRecordDao.listBy(orgId, openId, entityType);
	}

	@Override
	public void deleteByUniqueKey(OrgWechatOpenIdRecord record) {
		WechatOpenIdEntityType type = WechatOpenIdEntityType.getByValue(record.getEntityType());
		OrgWechatOpenIdRecord dbRecord = wechatOpenIdRecordDao.getBy(record.getAuthorizerAppId(), record.getOrgId(), record.getEntityId(), type);
	
		if(dbRecord!=null){
			wechatOpenIdRecordDao.delById(dbRecord.getId());
		}
	}

}

