/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.api.FansService;
import com.baijia.tianxiao.sal.wechat.api.MediaService;
import com.baijia.tianxiao.sal.wechat.api.WechatDataSyncService;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.task.FansSyncJob;
import com.baijia.tianxiao.sal.wechat.task.MediaNewsSyncJob;
import com.baijia.tianxiao.sal.wechat.task.TaskHelper;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;

@Slf4j
@Service
public class WechatDataSyncServiceImpl implements WechatDataSyncService{

	
	@Autowired
    private AuthorizerInfoService authorizerInfoService;
	@Autowired
    private AuthorizationInfoService authorizationInfoService;
	@Autowired
	private FansService fansService;
	@Autowired
	private MediaService mediaService;
	
	
	
	@Transactional(rollbackFor = Exception.class)
	@Override
	public void syncWechatData(Integer orgId) {
		AuthorizationInfo authorizationInfo = authorizationInfoService.getByOrgId(orgId);
		AuthorizerInfo authorizerInfo = authorizerInfoService.getByOrgId(orgId);
	
		if (authorizationInfo==null || authorizerInfo == null) {
			//不存在公众号的授权记录
			throw new BussinessException(SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
		}
		
		//同步 粉丝信息
        try {
        	WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.USER_LIST, true);
        	log.info("wechat - WechatDataSyncServiceImpl - syncWechatData - add fansSync task - appId:{}",authorizerInfo.getAuthorizerAppId());
			TaskHelper.getInstance().addTask( new FansSyncJob(fansService, authorizerInfo.getAuthorizerAppId(), authorizerInfoService) );
		} catch (Exception e) {
			log.warn("wechat - WechatDataSyncServiceImpl - syncWechatData - add fansSync task exception - appId:{}",authorizerInfo.getAuthorizerAppId());
			log.warn("",e);
		}
		
		//同步 图文素材
        try {
        	WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MEDIA, true);
        	log.info("wechat - WechatDataSyncServiceImpl - syncWechatData - add mediaNewsSync task - appId:{}",authorizerInfo.getAuthorizerAppId());
			TaskHelper.getInstance().addTask( new MediaNewsSyncJob(mediaService, authorizerInfo.getAuthorizerAppId(), authorizerInfoService) );
		} catch (Exception e) {
			log.warn("wechat - WechatDataSyncServiceImpl - syncWechatData - add mediaNewsSync task exception - appId:{}",authorizerInfo.getAuthorizerAppId());
			log.warn("",e);
		}
	}

}

