/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.impl;


import com.baijia.tianxiao.dal.activity.constants.TemplateConstant;
import com.baijia.tianxiao.dal.activity.dao.ActivityWechatReplaceDao;
import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.po.ActivityWechatReplace;
import com.baijia.tianxiao.dal.activity.po.Template;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomActivityDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatCustomActivity;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForKeyword;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.api.AutoReplyService;
import com.baijia.tianxiao.sal.wechat.api.CustomActivityService;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.dto.customactivity.CustomActivityDto;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeDto;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.qrcode.WechatQRCodeLinkHelper;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;
import com.baijia.tianxiao.util.ShortUrlUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.Date;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Service
public class CustomActivityServiceImpl implements CustomActivityService {

    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private OrgWechatCustomActivityDao customActivityDao;
    @Autowired
    private AuthorizerInfoService authorizerInfoService;
    @Autowired
    private AutoReplyService autoReplyService;
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private ActivityWechatReplaceDao activityWechatReplaceDao;

    
    
    @Transactional(rollbackFor = Exception.class)
    @Override
    public CustomActivityDto createCustomActivity(int orgId, int activityId, int activityType, String title,
        String description, String picUrl) throws Exception {

        AuthorizationInfo authorizationInfo = authorizationInfoService.refreshAccessToken(orgId);

        QRCodeDto qrCodeDto = WechatQRCodeLinkHelper.getQRCodeDtoForCustomActivity(authorizationInfo.getAuthorizerAccessToken(), activityId, activityType);
        String qrCodeImgUrl = WechatQRCodeLinkHelper.getGsxImgUrl(qrCodeDto);

        OrgWechatCustomActivity customActivity = new OrgWechatCustomActivity();
        customActivity.setAuthorizerAppId(authorizationInfo.getAuthorizerAppId());
        customActivity.setActivityType(activityType);
        customActivity.setActivityId(activityId);
        customActivity.setQrCodeUrl(qrCodeImgUrl);
        customActivity.setTitle(title);
        customActivity.setDescription(description);
        customActivity.setPicUrl(picUrl);
        customActivity.setCreateTime(new Date());

        try {
            customActivityDao.save(customActivity, true);
            log.info("wechat - CustomActivityServiceImpl - createCustomActivity - obj:{}", customActivity);
        } catch (Exception e) {
            log.error("wechat - CustomActivityServiceImpl - createCustomActivity - exception - obj:{}", customActivity);
            throw e;
        }

        String relativePath = TemplateConstant.getTemplateUrl(activityType);
        CustomActivityDto dto = new CustomActivityDto();
        dto.setActivityId(activityId);
        dto.setActivityType(activityType);
        dto.setAuthorizerAppId(authorizationInfo.getAuthorizerAppId());
        dto.setQrCodeUrl(qrCodeImgUrl);
        dto.setWebAuthUrl(WechatWebAuthLinkBuilder.customActivity(WebAuthScope.BASE,
            authorizationInfo.getAuthorizerAppId(), activityId, activityType, relativePath));
        return dto;
    }

    @Transactional(readOnly = true)
    @Override
    public CustomActivityDto getCustomActivity(int activityId, int activityType) {
        OrgWechatCustomActivity customActivity = customActivityDao.get(activityId, activityType);
        log.info("OrgWechatCustomActivity is : {} ", customActivity);
        if (customActivity == null) {
            return null;
        }
        Integer replaceId = customActivity.getReplaceOrgId();

        String qrCodeUrl = customActivity.getQrCodeUrl();
        if (replaceId != null && replaceId != -1) {
            AuthorizerInfo authorizerInfo = this.authorizerInfoService.getByOrgId(customActivity.getOriginOrgId());
            //有可能解绑，解绑后就不进行网页授权
            if(authorizerInfo == null){
                return null;
            }
            Integer qrcodeStorageId = authorizerInfo.getQrcodeStorageId();
            qrCodeUrl = retrievalImgUrl(qrcodeStorageId);
        }

        String relativePath = TemplateConstant.getTemplateUrl(activityType);

        CustomActivityDto dto = new CustomActivityDto();
        dto.setActivityId(activityId);
        dto.setActivityType(activityType);
        dto.setQrCodeUrl(qrCodeUrl);
        dto.setKeyWord(customActivity.getKeyWrod());
        dto.setReplaceOrgId(customActivity.getReplaceOrgId());
        dto.setWebAuthUrl(WechatWebAuthLinkBuilder.customActivity(WebAuthScope.BASE,
            customActivity.getAuthorizerAppId(), activityId, activityType, relativePath));
        return dto;
    }

    private String retrievalImgUrl(Integer qrcodeStorageId) {
        OrgStorage orgStorage = orgStorageDao.getById(qrcodeStorageId);
        if (orgStorage == null) {
            log.info("can not retrieval authorizerInfo's qrCodeUrl {} ", qrcodeStorageId);
            return null;
        }
        return StorageUtil.constructUrl(orgStorage.getFid(), orgStorage.getSn(), orgStorage.getMimeType());
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void deleteCustomActivity(int activityId, int activityType) {
        customActivityDao.deleteBy(activityId, activityType);
    }

    /**
     *
     */
    @Override
    public CustomActivityDto createCustomActivityForReplace(int replaceOrgId, int originOrgId, int activityId,
        int templateId, String title, String description, String picUrl) throws Exception {

        AuthorizerInfo authorizerInfo = this.authorizerInfoService.getByOrgId(originOrgId);
        if (authorizerInfo == null) {
            return null;
        }

        boolean needReplace = false;
        int orgId = originOrgId;
        if (!(authorizerInfo.isServiceApp() && authorizerInfo.isPassedVerify())) {
            orgId = replaceOrgId;
            needReplace = true;
            log.info(" not have enought permission ,and will replace with : {} ", replaceOrgId);
        }

        boolean passedVerify = authorizerInfo.isPassedVerify();
        Integer serviceType = authorizerInfo.getServiceType();
        boolean isSubscribeAccoutn = false;
        if (serviceType != null && (serviceType == 0 || serviceType == 1)) {
            isSubscribeAccoutn = true;
        }
        // 对于通过微信资质认证的订阅号，允许获取用户列表
        boolean needFilterSubscribe = !(passedVerify && isSubscribeAccoutn);

        CustomActivityDto createCustomActivity =
            this.createCustomActivity(orgId, activityId, templateId, title, description, picUrl);

        OrgWechatCustomActivity customActivity = this.customActivityDao.get(activityId, templateId);
        if (needReplace) {
            String keywordFormat = "[{'keyword':'%s','isExactMatch':1}]";
            String keyWord = createKeyWord(activityId, templateId);
            keyWord = String.format(keywordFormat, keyWord);
            log.info("keyword is : {} ", keyWord);
            MediaType mediaType = MediaType.ZIDINGYILIANJIE;
            // String content = createContent(activityId, templateId);
            customActivity.setKeyWrod(keyWord);
            // 使用原始的机构微信公众号进行自动回复的网页授权，否则拿不到用户同该机构的唯一openId
            // AuthorizationInfo authorizationInfo = this.authorizationInfoService.getByOrgId(originOrgId);
            // String relativePath = TemplateConstant.getTemplateUrl(templateId);
            // String url = WechatWebAuthLinkBuilder.customActivity(WebAuthScope.BASE,
            // authorizationInfo.getAuthorizerAppId(), activityId, templateId, relativePath);
            String url = createCustomActivity.getWebAuthUrl();
            // url = addParam(url);
            url = ShortUrlUtil.getShortUrl(url);
            // 创建关键字回复
            OrgWechatReplyForKeyword saveOrUpdateKeywordReply = autoReplyService.saveOrUpdateKeywordReply(originOrgId,
                null, keyWord, mediaType.getValue(), null, url, null, "");
            log.info("create autoReply obj is : {} ", saveOrUpdateKeywordReply);
            // 标记该客户活动使用的天校提供的认证服务号
            customActivity.setReplaceOrgId(replaceOrgId);
            // 设置原有机构的Id
            customActivity.setOriginOrgId(originOrgId);
            // 存储替换的信息
            saveReplaceInfo(originOrgId, replaceOrgId, needFilterSubscribe);
        }
        customActivity.setAuthorizerAppId(createCustomActivity.getAuthorizerAppId());
        customActivity.setQrCodeUrl(createCustomActivity.getQrCodeUrl());

        log.info("customActivity obj is : {} ", customActivity);

        try {
            customActivityDao.saveOrUpdate(customActivity);
            log.info("wechat - CustomActivityServiceImpl - createCustomActivity - obj:{}", customActivity);
        } catch (Exception e) {
            log.error("wechat - CustomActivityServiceImpl - createCustomActivity - exception - obj:{}", customActivity);
            throw e;
        }
        return createCustomActivity;
    }

    // @Test
    // public void test() {
    // String url =
    // "https://open.weixin.qq.com/connect/oauth2/authorize?&appid=wx227be953e1c83a0b&redirect_uri=http%3A%2F%2Ftest-crm-m.ctest.baijiahulian.com%2Fwechat%2Fwebauth%2Ffansinfo.do%3F%26landingPage%3Dhttp%253A%252F%252Ftest-marketing-m.ctest.baijiahulian.com%252F%252Ftoupiao.html%253FtemplateId%253D5%2526activityId%253D245%2526activityType%253D5%26scope%3Dsnsapi_base&response_type=code&scope=snsapi_base&state=&component_appid=wxe3e8b29a095c7a4f#wechat_redirect
    // ";
    // System.out.println(addParam(url));
    // }

    /**
     * 这样拼凑有些不靠谱
     * 
     * @param url
     * @return
     */
    @SuppressWarnings("unused")
    private static String addParam(String url) {
        log.info("url is : {} ", url);
        String find = "landingPage%3D";
        int indexOf = url.indexOf(find);
        int paramPathIndexOf = url.indexOf("%253F", indexOf);
        String preStr = url.substring(0, paramPathIndexOf);
        String nextStr = url.substring(paramPathIndexOf + 1);
        String retUrl = preStr + "%253FreplyFrom=wechatBackgroud%2526" + nextStr;
        return retUrl;
    }

    private void saveReplaceInfo(int originOrgId, int replaceOrgId, boolean needFilterSubscribe) {
        try {
            ActivityWechatReplace replace = new ActivityWechatReplace();
            replace.setOriginOrgId(originOrgId);
            replace.setReplaceOrgId(replaceOrgId);
            replace.setNeedFilterSubscribe(needFilterSubscribe ? 0 : 1);
            // 数据库控制记录的唯一性 unique(origin_org_id,replace_org_id)
            this.activityWechatReplaceDao.save(replace);
        } catch (DuplicateKeyException e) {
            // not Error
            log.info("has alerdy insert {} ", originOrgId + "_" + replaceOrgId);
        }
    }

    @SuppressWarnings("unused")
    private String createContent(int activityId, int activityType) {
        StringBuilder visitUrl = new StringBuilder();
        String relativePath = TemplateConstant.getTemplateUrl(activityType);
        visitUrl.append(WechatProperties.getWebMarketingUrlPrefix());
        visitUrl.append(relativePath);
        visitUrl.append("&activityId=").append(activityId);
        visitUrl.append("&activityType=").append(activityType);
        return visitUrl.toString();
    }

    private String createKeyWord(int activityId, int activityType) {
        String desc = createDescOfActivity(activityType);
        return desc + activityId;
    }

    /**
     * need update for everyTime has new activity type add <br/>
     * TODO
     * 
     * @param templateId
     * @return
     */
    private String createDescOfActivity(Integer templateId) {
        Template selectTemplateById = templateDao.selectTemplateById(templateId);
        Integer activityType = -1;
        if (selectTemplateById != null) {
            activityType = selectTemplateById.getTypeId();
        }
        switch (activityType) {
            case 3:
                return "微活动";
            case 99:
                return "抽奖";
            case 201:
                return "投票";
            case 301:
                return "转介绍";
            default:
                return "营销";
        }
    }

}