/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import java.util.Map;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatMenuDao;
import com.baijia.tianxiao.dal.wechat.dao.SubscribeQRCodeDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.sal.wechat.api.BindingService;
import com.baijia.tianxiao.sal.wechat.dto.binding.BindingInfoDto;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;
import com.google.common.collect.Maps;

/**
 * @Title : BindingServiceImpl
 * @Description :
 * @Author : zhenyujian
 * @Date : 2015年12月3日 下午3:29:26
 */
@Slf4j
@Service
public class BindingServiceImpl implements BindingService {

    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private OrgWechatMenuDao orgWechatMenuDao;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private SubscribeQRCodeDao subscribeQRCodeDao;
    
    
    @Transactional(readOnly = true)
    @Override
    public BindingInfoDto getBindingInfo(Integer orgId) {
        AuthorizerInfo info = authorizerInfoDao.getByOrgId(orgId);
        if (info == null) {
            return null;
        }

        BindingInfoDto dto = new BindingInfoDto();
        dto.setAppId(info.getAuthorizerAppId());
        dto.setHeadImg(info.getHeadImg());
        dto.setNickName(info.getNickName());
        dto.setServiceType(info.getServiceType());
        dto.setVerifyType(info.getVerifyType());
        dto.setUserName(info.getUserName());
        
        //二维码 链接地址
        String qrcodeUrl = null;
        if( info.getQrcodeStorageId()!=null ){
	        OrgStorage orgStorage = orgStorageDao.getById(info.getQrcodeStorageId());
	        if (orgStorage == null) {
	        	qrcodeUrl =  info.getQrcodeUrl();
	        } else {
	        	qrcodeUrl = StorageUtil.constructUrl(orgStorage.getFid(), orgStorage.getSn(), orgStorage.getMimeType());
	        }
        }
        dto.setQrcodeUrl(qrcodeUrl);
        
        return dto;
    }

    
    
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void removeBindingInfo(String appId) {
        AuthorizationInfo info = authorizationInfoDao.getByAuthorizerAppId(appId);
        if (info != null) {
        	Integer orgId = info.getOrgId();
        	log.info("wechat - removeBindingInfo - start - appId:{}, orgId:{}", appId, orgId);
            orgWechatMenuDao.deleteByOrgId(orgId);
            authorizerInfoDao.deleteByOrgId(orgId);
            authorizationInfoDao.deleteByOrgId(orgId);
            
            //清除公众号二位码图片
            Map<String, Object> condition = Maps.newHashMap();
            condition.put("authorizerAppId", appId);
            subscribeQRCodeDao.delByCondition(condition);
            
            log.info("wechat - removeBindingInfo - end - appId:{}, orgId:{}", appId, orgId);
        }else{
        	log.info("wechat - removeBindingInfo - AuthorizationInfo is null - appId:{}", appId);
        }
    }

}
