/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.BatchMsgService;
import com.baijia.tianxiao.sal.wechat.helper.sendmsg.batch.BatchMsgApiHelper;

/**
 * @Title : BatchMsgServiceImpl
 * @Description :群发消息
 * @Author : zhenyujian
 * @Date : 2015年12月3日 下午3:29:26
 */
@Slf4j
@Service
public class BatchMsgServiceImpl implements BatchMsgService {

    @Autowired
    private AuthorizationInfoService authorizationInfoService;

    
    @Transactional(readOnly = true)
    @Override
    public void sendMediaNews(Integer orgId, String mediaId, Integer groupId){
    	AuthorizationInfo authorizationInfo = authorizationInfoService.refreshAccessToken(orgId);
    	log.info("wechat - BatchMsgServiceImpl - sendMediaNews - appdI:{},mediaId:{},groupId:{}", authorizationInfo.getAuthorizerAppId(), mediaId, groupId);
    	BatchMsgApiHelper.sendMediaNews(authorizationInfo.getAuthorizerAccessToken(), mediaId, groupId);
    }
}
