/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import net.sf.json.JSONArray;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatReplyForKeywordDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatReplyForSubscribeDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForKeyword;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForSubscribe;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.PermissionException;
import com.baijia.tianxiao.sal.wechat.api.AutoReplyService;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.dto.autoreply.KeywordReplyDto;
import com.baijia.tianxiao.sal.wechat.dto.autoreply.SubscribeReplyDto;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.OrgWechatDto;
import com.baijia.tianxiao.sal.wechat.validator.AutoReplyValidator;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;


@Service
public class AutoReplyServiceImpl implements AutoReplyService{
	
	@Autowired
	private OrgWechatReplyForKeywordDao orgWechatReplyForKeywordDao;
	@Autowired
	private OrgWechatReplyForSubscribeDao orgWechatReplyForSubscribeDao;
	@Autowired
    private AuthorizerInfoDao authorizerInfoDao;
	@Autowired
	private OrgAccountDao orgAccountDao;
	
	
	
	@Transactional(rollbackFor = Exception.class)
	@Override
	public OrgWechatReplyForKeyword saveOrUpdateKeywordReply(Integer orgId, Integer id,
										 String keywords, int mediaType,
										 String mediaId, String url,
										 String content, String note) {
		//参数格式化
		if(mediaId==null) mediaId="";
		if(url==null) url="";
		if(content==null) content="";
		if(note==null) note="";
		
		if(StringUtils.isBlank(keywords)){
			keywords = "[]";
		}
		
		//参数验证
		MediaType type = MediaType.getByVaule(mediaType);
		if(type == MediaType.CONTENT){
			AutoReplyValidator._4Content(content);
		}
		JSONArray keywordsArray = JSONArray.fromObject(keywords);
		if(keywordsArray!=null && !keywordsArray.isEmpty()){
			for(int i=0;i<keywordsArray.size();i++){
				AutoReplyValidator._4Keyword( keywordsArray.getJSONObject(i).getString("keyword") );
			}
		}
		
		//执行业务逻辑
		AuthorizerInfo authorizerInfo = authorizerInfoDao.getByOrgId(orgId);
		OrgWechatReplyForKeyword reply = null;
		if(id!=null){
			reply = orgWechatReplyForKeywordDao.getById(id);
			if(reply == null){
				throw new PermissionException();
			}
		}
		
		if(authorizerInfo==null){
			throw new BussinessException(SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
		}
		if(reply!=null && !reply.getAuthorizerAppId().equals(authorizerInfo.getAuthorizerAppId())){
			throw new PermissionException();
		}
		
		Date now = new Date();
		OrgAccount orgAccount = orgAccountDao.getAccountById(authorizerInfo.getOrgId());
		OrgWechatDto orgWechatDto = new OrgWechatDto(orgAccount.getId(), orgAccount.getNumber(), authorizerInfo.getAuthorizerAppId());
		
		if (type == MediaType.ZIDINGYILIANJIE) {
            url = MediaType.fillUrlWithHttp(url);
        }
		
		if(reply==null){
			reply = new OrgWechatReplyForKeyword();
			reply.setAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
			reply.setContent(content);
			reply.setCreateTime(now);
			reply.setId(id);
			reply.setKeywords(keywords);
			reply.setMediaId(mediaId);
			reply.setMediaType(mediaType);
			reply.setUpdateTime(now);
			reply.setUrl( StringUtils.isNotBlank(url)?url:type.getUrl(orgWechatDto));
			reply.setNote(note);
			orgWechatReplyForKeywordDao.save(reply, true);
		}else{
			reply.setContent(content);
			reply.setKeywords(keywords);
			reply.setMediaId(mediaId);
			reply.setMediaType(mediaType);
			reply.setUpdateTime(now);
			reply.setUrl( StringUtils.isNotBlank(url)?url:type.getUrl(orgWechatDto) );
			reply.setNote(note);
			orgWechatReplyForKeywordDao.update(reply, true);
		}
		return reply;
	}

	
	
	@Transactional(rollbackFor = Exception.class)
	@Override
	public void delKeywordReply(Integer orgId, Integer id) {
		AuthorizerInfo authorizerInfo = authorizerInfoDao.getByOrgId(orgId);
		OrgWechatReplyForKeyword reply = null;
		
		if(id!=null){
			reply = orgWechatReplyForKeywordDao.getById(id);
			if(reply==null){
				throw new PermissionException();
			}
		}
		
		if(authorizerInfo==null){
			throw new BussinessException(SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
		}
		if(reply!=null && !reply.getAuthorizerAppId().equals(authorizerInfo.getAuthorizerAppId())){
			throw new PermissionException();
		}
		
		orgWechatReplyForKeywordDao.delById(id);
	}

	
	
	@Transactional(readOnly = true)
	@Override
	public List<KeywordReplyDto> listKeywordReply(Integer orgId, PageDto pageDto) {
		AuthorizerInfo authorizerInfo = authorizerInfoDao.getByOrgId(orgId);
		
		String authorizerAppId = authorizerInfo.getAuthorizerAppId();
		
		//分页查询
		Integer count = orgWechatReplyForKeywordDao.count(authorizerAppId);
		List<OrgWechatReplyForKeyword> list = null;
		if(count>0){
			list = orgWechatReplyForKeywordDao.search(authorizerAppId, pageDto);
		}else{
			list = new ArrayList<OrgWechatReplyForKeyword>();
		}
		pageDto.setCurPageCount(list.size());
		pageDto.setCount(count);
		
		//结果转换
		List<KeywordReplyDto> dtoList = new ArrayList<KeywordReplyDto>();
		if(list!=null && !list.isEmpty()){
			KeywordReplyDto dto;
			for(OrgWechatReplyForKeyword replyForKeyword:list){
				dto = new KeywordReplyDto();
				dto.setContent( replyForKeyword.getContent() );
				dto.setId( replyForKeyword.getId() );
				dto.setKeywords( JSONArray.fromObject(replyForKeyword.getKeywords()) );
				dto.setMediaId( replyForKeyword.getMediaId());
				dto.setMediaType( replyForKeyword.getMediaType() );
				dto.setUrl( replyForKeyword.getUrl() );
				dto.setNote( replyForKeyword.getNote() );
				//FIXME 兼容 android ios
				if(StringUtils.isBlank(dto.getNote())){
					MediaType type = MediaType.getByVaule(dto.getMediaType());
					String fmt="[%s]%s";
					String body = "";
					if(type==MediaType.CONTENT && dto.getContent()!=null){
						body = dto.getContent();
					}else if(type==MediaType.ZIDINGYILIANJIE && dto.getUrl()!=null){
						body = dto.getUrl();
					}
					fmt = String.format(fmt, type.getLabel(), body );
					dto.setNote(fmt);
				}
				dtoList.add(dto);
			}
		}
		
		return dtoList;
	}

	
	
	
	@Transactional(rollbackFor = Exception.class)
	@Override
	public void saveOrUpdateSubscribeReply(Integer orgId,
										   int mediaType, String mediaId,
										   String url, String content,
										   String note) {
		if(mediaId==null) mediaId="";
		if(url==null) url="";
		if(content==null) content="";
		if(note==null) note="";
		
		//参数验证
		MediaType type = MediaType.getByVaule(mediaType);
		if(type == MediaType.CONTENT){
			AutoReplyValidator._4Content(content);
		}
				
		//执行业务逻辑
		AuthorizerInfo authorizerInfo = authorizerInfoDao.getByOrgId(orgId);
		if(authorizerInfo==null){
			throw new BussinessException(SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
		}
		
		OrgWechatReplyForSubscribe reply = orgWechatReplyForSubscribeDao.getByAppId(authorizerInfo.getAuthorizerAppId());
		
		if(reply!=null && !reply.getAuthorizerAppId().equals(authorizerInfo.getAuthorizerAppId())){
			throw new PermissionException();
		}
		
		Date now = new Date();
		OrgAccount orgAccount = orgAccountDao.getAccountById(authorizerInfo.getOrgId());
		OrgWechatDto orgWechatDto = new OrgWechatDto(orgAccount.getId(), orgAccount.getNumber(), authorizerInfo.getAuthorizerAppId());
		
		if (type == MediaType.ZIDINGYILIANJIE) {
            url = MediaType.fillUrlWithHttp(url);
        }
		
		if(reply==null){
			reply = new OrgWechatReplyForSubscribe();
			reply.setAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
			reply.setContent(content);
			reply.setCreateTime(now);
			reply.setId(null);
			reply.setMediaId(mediaId);
			reply.setMediaType(mediaType);
			reply.setUpdateTime(now);
			reply.setUrl( StringUtils.isNotBlank(url)?url:type.getUrl(orgWechatDto));
			reply.setNote(note);
			orgWechatReplyForSubscribeDao.save(reply, true);
		}else{
			reply.setContent(content);
			reply.setMediaId(mediaId);
			reply.setMediaType(mediaType);
			reply.setUpdateTime(now);
			reply.setUrl( StringUtils.isNotBlank(url)?url:type.getUrl(orgWechatDto));
			reply.setNote(note);
			orgWechatReplyForSubscribeDao.update(reply, true);
		}
	}

	
	
	@Transactional(readOnly = true)
	@Override
	public SubscribeReplyDto getSubscribeReply(Integer orgId) {
		SubscribeReplyDto dto = null;
		
		AuthorizerInfo authorizerInfo = authorizerInfoDao.getByOrgId(orgId);
		
		if(authorizerInfo==null){
			throw new BussinessException(SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
		}
		
		OrgWechatReplyForSubscribe reply = orgWechatReplyForSubscribeDao.getByAppId(authorizerInfo.getAuthorizerAppId());
		if(reply != null){
			dto = new SubscribeReplyDto();
			dto.setContent(reply.getContent());
			dto.setId(reply.getId());
			dto.setMediaId(reply.getMediaId());
			dto.setMediaType(reply.getMediaType());
			dto.setUrl(reply.getUrl());
			dto.setNote(reply.getNote());
		}
		return dto;
	}

}

