/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoCallbackHandler;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.api.FansService;
import com.baijia.tianxiao.sal.wechat.api.MediaService;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.dto.request.AuthorizationInfoCallbackRequest;
import com.baijia.tianxiao.sal.wechat.task.FansSyncJob;
import com.baijia.tianxiao.sal.wechat.task.MediaNewsSyncJob;
import com.baijia.tianxiao.sal.wechat.task.TaskHelper;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;


/**
 * @Title       : AuthorizationInfoCallbackHandlerImpl
 * @Description : 公众号绑定(授权)流程 回调(使用authCode获取授权信息)
 * @Author      : zhenyujian
 * @Date        : 2015年12月3日 下午2:23:34
 */
@Slf4j
@Service
public class AuthorizationInfoCallbackHandlerImpl implements AuthorizationInfoCallbackHandler {

	@Autowired
    private AuthorizerInfoService authorizerInfoService;
	@Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private FansService fansService;
    @Autowired
    private MediaService mediaService;

    
    
    
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void handle(AuthorizationInfoCallbackRequest request) {
        AuthorizationInfo authorizationInfo = authorizationInfoService.addAuthorizationInfo(request.getOrgId(), request.getAuthCode());
        AuthorizerInfo authorizerInfo = authorizerInfoService.syncAuthorizerInfo(request.getOrgId(), authorizationInfo.getAuthorizerAppId());

        //同步粉丝信息
        try{
	        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.USER_LIST, true);
	        try {
	        	log.info("wechat - AuthorizationInfoCallbackHandlerImpl - handle - add fansSync task - appId:{}",authorizerInfo.getAuthorizerAppId());
				TaskHelper.getInstance().addTask( new FansSyncJob(fansService, authorizerInfo.getAuthorizerAppId(), authorizerInfoService) );
			} catch (Exception e) {
				log.error("wechat - AuthorizationInfoCallbackHandlerImpl - handle - fansSync - exception",e);
			}
        }catch(Exception e){
        	log.info("wechat - AuthorizationInfoCallbackHandlerImpl - handle - fansSync",e);
        }
        
        //同步素材信息
        try{
        	WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MEDIA, true);
	        try {
	        	log.info("wechat - AuthorizationInfoCallbackHandlerImpl - handle - add mediaNewsSync task - appId:{}",authorizerInfo.getAuthorizerAppId());
				TaskHelper.getInstance().addTask( new MediaNewsSyncJob(mediaService, authorizerInfo.getAuthorizerAppId(), authorizerInfoService) );
			} catch (Exception e) {
				log.error("wechat - AuthorizationInfoCallbackHandlerImpl - handle - fansSync - exception",e);
			}
        }catch(Exception e){
        	log.info("wechat - AuthorizationInfoCallbackHandlerImpl - handle - fansSync",e);
        }
        
        log.info("wechat - AuthorizationInfoCallbackHandlerImpl - handle - request:{}",request);
    }

    
    
	@Override
	public void handleTest(AuthorizationInfoCallbackRequest request) {
		log.info("*************************a啊b  request:"+request);
        AuthorizationInfo authorizationInfo = authorizationInfoService.addAuthorizationInfo(request.getOrgId(), request.getAuthCode());
        log.info("*************************a啊b  authorizationInfo:"+authorizationInfo);
        authorizerInfoService.syncAuthorizerInfo(request.getOrgId(), authorizationInfo.getAuthorizerAppId());
        log.info("*************************a啊b  end:");
	}
}
