/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.user;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.WechatRemoteCallHelper;
import com.baijia.tianxiao.util.date.DateUtil;

/**
 * @Title : OpenPlatformApiCaller
 * @Description : 微信公众平台 用户管理相关接口
 * @Author : zhenyujian
 * @Date : 2015年12月3日 上午11:01:58
 */
public class FansServiceApiHelper {

    /**
     * @Description : 获取用户详细信息
     * @Author : zhenyujian
     * @Date : 2015年12月7日 下午8:37:14
     * 
     * @Return : WechatApiResponse
     */
    public static Fans getFansInfo(String accessToken, String openId) throws WechatException, WebServiceException {
        Fans fans = new Fans();
        String url =
            "https://api.weixin.qq.com/cgi-bin/user/info?access_token=" + accessToken + "&openid=" + openId
                + "&lang=zh_CN";
        Map<String, Object> params = new HashMap<String, Object>();

        WechatApiResponse response = WechatRemoteCallHelper.postJson(url, params);
        JSONObject rootNode = response.getRootJSONObj();
        if(rootNode.getInt("subscribe")==0){
        	return null;
        }
        fans.setCity(rootNode.optString("city",""));
        fans.setCountry(rootNode.optString("country",""));
        fans.setGroupId(rootNode.optInt("groupid",-1));
        fans.setHeadImgUrl(rootNode.optString("headimgurl",""));
        fans.setLanguage(rootNode.optString("language",""));
        fans.setNick(rootNode.optString("nickname",""));
        fans.setOpenId(rootNode.getString("openid"));
        fans.setProvince(rootNode.optString("province",""));
        fans.setRemark(rootNode.optString("remark",""));
        fans.setSex(rootNode.optInt("sex",1));
        fans.setSubscribe(rootNode.getInt("subscribe"));
        fans.setSubscribeTime(DateUtil.UnixTimestamp2Date(rootNode.getLong("subscribe_time")));
        return fans;
    }

    /**
     * @Description : 获取粉丝列表
     * @Author : zhenyujian
     * @Date : 2015年12月7日 下午7:56:50
     * 
     * @Return : WechatApiResponse
     */
    public static List<String> getAllFansOpenIdList(String accessToken) {
        List<String> openIds = new ArrayList<String>();
        WechatApiResponse response = FansServiceApiCaller.getFansOpenIdList(accessToken, null);
        
        JSONObject rootNode = response.getRootJSONObj();
        String nextOpenId = rootNode.optString("next_openid");
        if( StringUtils.isBlank(nextOpenId) ){
        	return openIds;
        }
        JSONObject data = rootNode.getJSONObject("data");
        JSONArray openIdArray = data.getJSONArray("openid");
        if (openIdArray != null && openIdArray.size() > 0) {
            for (int i = 0; i < openIdArray.size(); i++) {
                openIds.add(openIdArray.getString(i));
            }
        }
        
        while( StringUtils.isNotBlank(nextOpenId) ){
        	response = FansServiceApiCaller.getFansOpenIdList(accessToken, nextOpenId);
        	rootNode = response.getRootJSONObj();
            nextOpenId = rootNode.optString("next_openid");
            if( StringUtils.isBlank(nextOpenId) ){
            	break;
            }
            
            data = rootNode.getJSONObject("data");
            openIdArray = data.getJSONArray("openid");
            if (openIdArray != null && openIdArray.size() > 0) {
                for (int i = 0; i < openIdArray.size(); i++) {
                    openIds.add(openIdArray.getString(i));
                }
            }
        }
        
        return openIds;
    }

    /**
     * @Description : 设置微信备注
     * @Author : zhenyujian
     * @Date : 2015年12月7日 下午7:59:33
     * 
     * @Return : WechatApiResponse
     */
    public static WechatApiResponse remark(String accessToken, String openId, String remark) {
    	return FansServiceApiCaller.remark(accessToken, openId, remark);
    }
    
    
    /**
     * @Description  : 获取粉丝数
     * @Author       : zhenyujian
     * @Date         : 2016年1月7日 下午4:45:15 
     *
     * @Return       : int
     */
    public static int getFansCount(String accessToken) {
    	WechatApiResponse response = FansServiceApiCaller.getFansOpenIdList(accessToken, null);
        JSONObject rootNode = response.getRootJSONObj();
        return rootNode.optInt("total",0);
    }
    
}
