/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.template;



import net.sf.json.JSONObject;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;


/**   
 * @title       : TemplateMsgHelper 
 * @description : 模板消息
 * @author      : zhenyujian
 * @date        : 2016年1月6日 上午12:44:59 
 */
public class TemplateMsgHelper {
	
	
	
	/**
	 * @Description  : 为公众号绑定添加模板
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月6日 上午1:41:59 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static String bindTemplate(String accessToken, String originalTemplateId){
		WechatApiResponse result = TemplateMsgCaller.bindTemplate(accessToken, originalTemplateId);
		JSONObject rootNode = result.getRootJSONObj();
		return rootNode.getString("template_id");
	}
	
	
	/**
	 * @Description  : 发送模板消息
	 * @Author       : zhenyujian
	 * @CreationDate : 2015年7月8日 下午5:08:48 
	 *
	 * @Return       : void
	 */
	public static WechatApiResponse sendTemplateMsg(String accessToken, String json){
		return TemplateMsgCaller.sendTemplateMsg(accessToken, json);
	}

}

