/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.autoreply;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForKeyword;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForSubscribe;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.sendmsg.customer.CustomerServiceApiCaller;

import lombok.extern.slf4j.Slf4j;

/**
 * @title : AutoReplyHelper
 * @description : 自动回复 (通过调用客服接口方式 需要具有客服接口权限)
 * @author : zhenyujian
 * @date : 2016年1月5日 上午12:30:14
 */
@Slf4j
public class AutoReplyHelper {

    /**
     * @Description : 发送关注回复消息
     * @Author : zhenyujian
     * @Date : 2016年1月5日 上午11:58:36
     *
     * @Return : boolean
     */
    public static boolean sendSubscribeReply(String accessToken, String toOpenId, OrgWechatReplyForSubscribe reply) {
        if (reply == null) {
            return false;
        }

        try {
            WechatApiResponse result = null;
            MediaType type = MediaType.getByVaule(reply.getMediaType());

            if (MediaType.UNKNOWN == type) {// 占位元素
                return true;

            } else if (MediaType.IMAGE == type) {// 图片消息
                result = CustomerServiceApiCaller.sendImageMsg(accessToken, toOpenId, reply.getMediaId());
            } else if (MediaType.VOICE == type) {
            } else if (MediaType.VIDEO == type) {
            } else if (MediaType.THUMB == type) {
            } else if (MediaType.NEWS == type) {// 图文消息
                if (reply.getMediaId() != null) {
                    result = CustomerServiceApiCaller.sendNewsMsg(accessToken, toOpenId, reply.getMediaId());
                }

            } else if (MediaType.CONTENT == type) {// 文本消息
                if (StringUtils.isNotBlank(reply.getContent())) {
                    result = CustomerServiceApiCaller.sendTextMsg(accessToken, toOpenId, reply.getContent());
                }

            } else if (MediaType.WANGXIAOZHUYE == type || MediaType.KECHENGDANYE == type || MediaType.HUODONG == type
                || MediaType.KECHENGLIEBIAO == type || MediaType.ZIDINGYILIANJIE == type || MediaType.WODEKEBIAO == type
                || MediaType.WODEPINGJIA == type || MediaType.GERENZHONGXIN == type) {
                // //链接消息
                // if(StringUtils.isNotBlank(reply.getUrl())){
                // result = CustomerServiceApiCaller.sendTextMsg(accessToken, toOpenId, reply.getUrl());
                // }
                if (StringUtils.isNotBlank(reply.getUrl())) {
                    String fmt = "【%s】\n%s";
                    fmt = String.format(fmt, type.getLabel(), reply.getUrl());
                    result = CustomerServiceApiCaller.sendTextMsg(accessToken, toOpenId, fmt);
                }

            }

            if (result != null && result.getCode() == 0) {
                return true;
            } else {
                return false;
            }
        } catch (WechatException e) {
            log.warn("wechat - AutoReplyHelper - sendSubscribeReply fail - toOpenId:{}, reply:{}", toOpenId, reply);
            log.warn("wechat - AutoReplyHelper - sendSubscribeReply fail - e:{}", e);
            return false;
        } catch (Exception e) {
            log.warn("wechat - AutoReplyHelper - sendSubscribeReply fail - toOpenId:{}, reply:{}", toOpenId, reply);
            log.warn("wechat - AutoReplyHelper - sendSubscribeReply fail - e:{}", e);
            return false;
        }
    }

    /**
     * @Description : 发送关键词回复消息
     * @Author : zhenyujian
     * @Date : 2016年1月5日 下午3:46:23
     *
     * @Return : boolean
     */
    public static boolean sendKeywordReply(String accessToken, String toOpenId, OrgWechatReplyForKeyword reply) {
        if (reply == null) {
            return false;
        }

        try {
            WechatApiResponse result = null;
            MediaType type = MediaType.getByVaule(reply.getMediaType());

            log.info("mediaType is : {} ", type);
            if (MediaType.UNKNOWN == type) {// 占位元素
                return true;

            } else if (MediaType.IMAGE == type) {// 图片消息
                result = CustomerServiceApiCaller.sendImageMsg(accessToken, toOpenId, reply.getMediaId());

            } else if (MediaType.IMAGE == type) {
            } else if (MediaType.VOICE == type) {
            } else if (MediaType.VIDEO == type) {
            } else if (MediaType.THUMB == type) {
            } else if (MediaType.NEWS == type) {// 图文消息
                if (reply.getMediaId() != null) {
                    result = CustomerServiceApiCaller.sendNewsMsg(accessToken, toOpenId, reply.getMediaId());
                }

            } else if (MediaType.CONTENT == type) {// 文本消息
                if (StringUtils.isNotBlank(reply.getContent())) {
                    result = CustomerServiceApiCaller.sendTextMsg(accessToken, toOpenId, reply.getContent());
                }
            } else if (MediaType.WANGXIAOZHUYE == type || MediaType.KECHENGDANYE == type || MediaType.HUODONG == type
                || MediaType.KECHENGLIEBIAO == type || MediaType.ZIDINGYILIANJIE == type || MediaType.WODEKEBIAO == type
                || MediaType.WODEPINGJIA == type || MediaType.GERENZHONGXIN == type) {
                log.info("------------");
                if (StringUtils.isNotBlank(reply.getUrl())) {
                    String fmt = "【%s】\n%s";
                    fmt = String.format(fmt, type.getLabel(), reply.getUrl());
                    result = CustomerServiceApiCaller.sendTextMsg(accessToken, toOpenId, fmt);
                }
            }

            if (result != null && result.getCode() == 0) {
                return true;
            } else {
                return false;
            }
        } catch (WechatException e) {
            log.warn("wechat - AutoReplyHelper - sendKeywordReply fail - toOpenId:{}, reply:{}", toOpenId, reply);
            log.warn("wechat - AutoReplyHelper - sendSubscribeReply fail - e:{}", e);
            return false;
        } catch (Exception e) {
            log.warn("wechat - AutoReplyHelper - sendKeywordReply fail - toOpenId:{}, reply:{}", toOpenId, reply);
            log.warn("wechat - AutoReplyHelper - sendSubscribeReply fail - e:{}", e);
            return false;
        }
    }

}
