/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.mediatype;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;

import lombok.Data;

@Data
public class MediaTypeDto {
	private String name;
	private int mediaType;
	private String url;
	
	public MediaTypeDto(MediaType type, OrgWechatDto orgWechatDto){
		this.name = type.getLabel();
		this.mediaType = type.getValue();
		this.url = type.getUrl(orgWechatDto);
	}
	
	
	@Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
    
}

