/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.api;

import java.util.List;

import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.exception.CustomException;
import com.baijia.tianxiao.sal.wechat.dto.fans.FansDetailDto;
import com.baijia.tianxiao.sal.wechat.dto.fans.FansListDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

/**   
 * @title       : FansService 
 * @description : 微信粉丝相关
 * @author      : zhenyujian
 * @date        : 2015年12月12日 下午8:45:57 
 */
public interface FansService {
	
	/**
	 * @Description  : 判断是否需要进行粉丝同步操作
	 * @Author       : zhenyujian
	 */
	public boolean isNeedToSync(int orgId);
	
	
	/**
	 * @Description  : 分页查询 粉丝 
	 * @Author       : zhenyujian
	 */
	public FansListDto listFans(Integer orgId, String searchText, PageDto pageDto) throws CustomException;
	
	
	/**
	 * @Description  : 查询 粉丝详情 
	 * @Author       : zhenyujian
	 */
	public FansDetailDto getFansDetail(String openId);
	
	
	/**
	 * @Description  : 数据同步(从微信同步到本地) 微信粉丝
	 * @Author       : zhenyujian
	 */
	public void syncFans(String authorizerAppId);
	
	
	/**
	 * @Description  : 给粉丝设置备注 (会调用微信接口) 
	 * @Author       : zhenyujian
	 */
	public void remark(Integer orgId, String openId, String remark);
	
	
	/**
	 * @Description  : 保存、更新 粉丝 
	 * @Author       : zhenyujian
	 */
	public void saveOrUpdateFans(Fans fans);
	
	
	public Fans getFans(int orgId, String openId);
	
	
	public Fans getFans(String openId);
	
	
	public void batchSaveFans(List<Fans> fansList);
	
	/**
	 * @Description  : 转换微信粉丝头像地址  微信url -> 百家url 
	 * @Author       : zhenyujian
	 * @Date         : 2016年8月6日 上午11:34:37 
	 *
	 * @Return       : void
	 */
	String convertFansHeadImg(Long orgId, Fans fans);
	
	void batchConvertFansHeadImg(String authorizerAppId);
}

