/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.api;

import com.baijia.tianxiao.sal.wechat.dto.custommenu.CustomMenuDto;

/**   
 * @title       : CustomMenuService 
 * @description : 微信自定义菜单
 * @author      : zhenyujian
 * @date        : 2016年1月8日 下午3:07:53 
 */
public interface CustomMenuService {
	
	/**
	 * @Description  : 同步公众号现有自定义菜单 (暂未实现、使用  无法处理微信中的click类型按钮)
	 * @Author       : zhenyujian
	 */
	public boolean syncCustomMenu(int orgId);
	
	
	/**
	 * @Description  : 保存、生成 自定义菜单
	 * @Author       : zhenyujian
	 */
	public void saveAndBuildCustomMenu(int orgId, String menuJson);
	
	
	/**
	 * @Description  : 查询 自定义菜单
	 * @Author       : zhenyujian
	 */
	public CustomMenuDto getCustomMenu(int orgId);
	
	
	/**
	 * @Description  : 查询 ‘一键生成’ 自定义菜单格式
	 * @Author       : zhenyujian
	 */
	public String getQuickMenuJson(int orgId);
	
	
	@Deprecated
	public void mediaTypeConvert();
	
	/**
	 * @Description  : 免费版自定义菜单
	 * @Author       : zhenyujian
	 * @Date         : 2016年8月29日 上午12:08:47 
	 *
	 * @Return       : void
	 */
	public String createMenuForFreeVersion();
	
}





