/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.commons.configs.GenericsConfiguration;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.JsAPISDKService;
import com.baijia.tianxiao.sal.wechat.dto.JSSDK.JsApiTicket;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.util.JSSDKUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.TwoTuple;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

@Service
public class JsAPISDKServiceImpl
implements JsAPISDKService {
    private static final Logger log = LoggerFactory.getLogger(JsAPISDKServiceImpl.class);
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsApiTicket retrievalJsApiTicket(Integer orgId) {
        AuthorizationInfo authorizationInfo;
        RedisConnection connection;
        block20: {
            block21: {
                JsApiTicket ticket;
                block22: {
                    connection = null;
                    authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
                    if (authorizationInfo == null) {
                        log.info("current org can not retrieval the jsApiTicket cause by no bind");
                        return null;
                    }
                    if (this.redisTemplate == null) break block20;
                    log.info("\u83b7\u53d6\u5230redis\u8fde\u63a5");
                    connection = this.redisTemplate.getConnectionFactory().getConnection();
                    connection.select(WechatProperties.getRedisDB().intValue());
                    String redisKey = this.generateKey(authorizationInfo);
                    byte[] bs = connection.get(redisKey.getBytes());
                    RedisSerializer redisSerializer = this.redisTemplate.getDefaultSerializer();
                    Object deserialize = redisSerializer.deserialize(bs);
                    if (deserialize == null || GenericsConfiguration.needForceReGetJsApiTicket()) break block21;
                    ticket = (JsApiTicket)deserialize;
                    log.info("JsApiTicket \u8fc7\u671f\u65f6\u95f4 param:{}", (Object)ticket.getExpiresIn());
                    boolean isexpire = this.isAccessTokenExpired(ticket.getCreateTime());
                    log.info("[JsApiTicket] isexpire param:{}", (Object)isexpire);
                    if (!isexpire) break block22;
                    JsApiTicket jsApiTicket = this.refreshTicket(connection, authorizationInfo);
                    if (connection == null) return jsApiTicket;
                    try {
                        RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
                        return jsApiTicket;
                    }
                    catch (Exception e) {
                        log.info("can not releaseConnection cause by : {} ", e.getCause());
                    }
                    return jsApiTicket;
                }
                log.info("JsApiTicket ticket param:{}, appId param:{}", (Object)ticket, (Object)authorizationInfo.getAuthorizerAppId());
                JsApiTicket jsApiTicket = ticket;
                if (connection == null) return jsApiTicket;
                try {
                    RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
                    return jsApiTicket;
                }
                catch (Exception e) {
                    log.info("can not releaseConnection cause by : {} ", e.getCause());
                }
                return jsApiTicket;
            }
            log.info("can not find any jsApiTicket from redis or it is expired , will lock and refresh api_ticket");
            JsApiTicket jsApiTicket = this.refreshTicket(connection, authorizationInfo);
            if (connection == null) return jsApiTicket;
            try {
                RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
                return jsApiTicket;
            }
            catch (Exception e) {
                log.info("can not releaseConnection cause by : {} ", e.getCause());
            }
            return jsApiTicket;
        }
        log.info("find a null instance for redisTemplate and can not retrieval the jsApiTicket");
        if (connection == null) return this.reGetTicket(authorizationInfo);
        try {
            RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
            return this.reGetTicket(authorizationInfo);
        }
        catch (Exception e) {
            log.info("can not releaseConnection cause by : {} ", e.getCause());
        }
        return this.reGetTicket(authorizationInfo);
        catch (Exception e) {
            try {
                log.error("can not retrieval jsapitTicket cause by : {} and will return it without reset it to redis server ", (Throwable)e);
                if (connection == null) return this.reGetTicket(authorizationInfo);
            }
            catch (Throwable throwable) {
                if (connection == null) throw throwable;
                try {
                    RedisConnectionUtils.releaseConnection(connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
                    throw throwable;
                }
                catch (Exception e2) {
                    log.info("can not releaseConnection cause by : {} ", e2.getCause());
                }
                throw throwable;
            }
            try {
                RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
                return this.reGetTicket(authorizationInfo);
            }
            catch (Exception e3) {
                log.info("can not releaseConnection cause by : {} ", e3.getCause());
            }
            return this.reGetTicket(authorizationInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsApiTicket refreshTicket(RedisConnection connection, AuthorizationInfo authorizationInfo) {
        String lockKey = this.getLockKey(authorizationInfo);
        JsApiTicket jat = null;
        if (connection.setNX(lockKey.getBytes(), "".getBytes()).booleanValue()) {
            block10: {
                JsApiTicket jsApiTicket;
                try {
                    connection.expire(lockKey.getBytes(), 20L);
                    jat = this.reGetTicket(authorizationInfo);
                    if (!GenericsUtils.isNullOrEmpty((Object)jat.getJsApiTicket())) break block10;
                    jsApiTicket = null;
                }
                catch (Throwable throwable) {
                    try {
                        connection.del((byte[][])new byte[][]{lockKey.getBytes()});
                    }
                    catch (Exception e) {
                        log.info("can not del key cause by : {} , and need reset ", e.getCause());
                    }
                    throw throwable;
                }
                try {
                    connection.del((byte[][])new byte[][]{lockKey.getBytes()});
                }
                catch (Exception e) {
                    log.info("can not del key cause by : {} , and need reset ", e.getCause());
                }
                return jsApiTicket;
            }
            RedisSerializer redisSerializer = this.redisTemplate.getDefaultSerializer();
            log.info("JsApiTicket jat param:{}", (Object)jat);
            connection.set(this.generateKey(authorizationInfo).getBytes(), redisSerializer.serialize((Object)jat));
            connection.expire(this.generateKey(authorizationInfo).getBytes(), (long)jat.getExpiresIn().intValue());
            try {
                connection.del((byte[][])new byte[][]{lockKey.getBytes()});
            }
            catch (Exception e) {
                log.info("can not del key cause by : {} , and need reset ", e.getCause());
            }
        }
        return jat;
    }

    public JsApiTicket reGetTicket(AuthorizationInfo authorizationInfo) {
        JsApiTicket jat = null;
        String accessToken = authorizationInfo.getAuthorizerAccessToken();
        log.info("accessToken param:{}", (Object)accessToken);
        TwoTuple<String, Integer> apiTicket = JSSDKUtils.trievalJsApiTicket(accessToken);
        String apiTicketStr = (String)apiTicket.first;
        Integer expiredTime = (Integer)apiTicket.second;
        expiredTime = expiredTime == null ? JsAPISDKService.JS_API_EXPIRED : expiredTime;
        jat = new JsApiTicket();
        jat.setExpiresIn(expiredTime);
        jat.setJsApiTicket(apiTicketStr);
        jat.setOrgId(authorizationInfo.getOrgId());
        jat.setCreateTime(new Date());
        jat.setAppId(authorizationInfo.getAuthorizerAppId());
        return jat;
    }

    private String getLockKey(AuthorizationInfo authorizationInfo) {
        return "lock.jsApiTicket_1." + authorizationInfo.getOrgId();
    }

    private String generateKey(AuthorizationInfo authorizationInfo) {
        return "key.jsApiTicket." + authorizationInfo.getOrgId();
    }

    public boolean isAccessTokenExpired(Date createTime) {
        Date now = new Date();
        return now.getTime() / 1000L - createTime.getTime() / 1000L >= (long)JsAPISDKService.JS_API_EXPIRED.intValue();
    }
}

