/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatMenuDao;
import com.baijia.tianxiao.dal.wechat.dao.SubscribeQRCodeDao;
import com.baijia.tianxiao.dal.wechat.dao.UnifiedWechatAccountDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.sal.wechat.api.BindingService;
import com.baijia.tianxiao.sal.wechat.dto.binding.BindingInfoDto;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BindingServiceImpl
implements BindingService {
    private static final Logger log = LoggerFactory.getLogger(BindingServiceImpl.class);
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private OrgWechatMenuDao orgWechatMenuDao;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private SubscribeQRCodeDao subscribeQRCodeDao;
    @Autowired
    private UnifiedWechatAccountDao unifiedWechatAccountDao;
    @Autowired
    private OrgSubAccountDao orgSubaccountDao;

    @Override
    @Transactional(readOnly=true)
    public BindingInfoDto getBindingInfo(Integer orgId) {
        AuthorizerInfo info = this.authorizerInfoDao.getByOrgId(orgId);
        log.info("authorizerInfo : {} ", (Object)info);
        if (info == null) {
            return null;
        }
        BindingInfoDto dto = new BindingInfoDto();
        dto.setAppId(info.getAuthorizerAppId());
        dto.setHeadImg(info.getHeadImg());
        dto.setNickName(info.getNickName());
        dto.setServiceType(info.getServiceType());
        dto.setVerifyType(info.getVerifyType());
        dto.setUserName(info.getUserName());
        dto.setOrgWechatType(info.getOrgWechatType());
        log.info("service dto is :{} ", (Object)dto);
        String qrcodeUrl = null;
        if (info.getQrcodeStorageId() != null) {
            OrgStorage orgStorage = this.orgStorageDao.getById(info.getQrcodeStorageId().intValue());
            qrcodeUrl = orgStorage == null ? info.getQrcodeUrl() : StorageUtil.constructUrl(orgStorage.getFid(), orgStorage.getSn(), orgStorage.getMimeType());
        }
        dto.setQrcodeUrl(qrcodeUrl);
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBindingInfo(String appId) {
        AuthorizationInfo info = this.authorizationInfoDao.getByAuthorizerAppId(appId);
        log.info("wechat - removeBindingInfo - start - appId:{},info\uff1a{}", (Object)appId, (Object)info);
        if (info != null) {
            Integer orgId = info.getOrgId();
            log.info("wechat - removeBindingInfo - start - appId:{}, orgId:{}", (Object)appId, (Object)orgId);
            this.orgWechatMenuDao.deleteByOrgId(orgId.intValue());
            this.authorizerInfoDao.deleteByOrgId(orgId);
            this.authorizationInfoDao.deleteByOrgId(orgId);
            this.orgSubaccountDao.resetOrgWechatType(orgId);
            this.unifiedWechatAccountDao.deleteByOrgId(Long.valueOf(orgId.longValue()));
            HashMap condition = Maps.newHashMap();
            condition.put("authorizerAppId", appId);
            this.subscribeQRCodeDao.delByCondition((Map)condition);
            log.info("wechat - removeBindingInfo - end - appId:{}, orgId:{}", (Object)appId, (Object)orgId);
        } else {
            log.info("wechat - removeBindingInfo - AuthorizationInfo is null - appId:{}", (Object)appId);
        }
    }
}

