/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.BatchMsgService;
import com.baijia.tianxiao.sal.wechat.helper.sendmsg.batch.BatchMsgApiHelper;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BatchMsgServiceImpl
implements BatchMsgService {
    private static final Logger log = LoggerFactory.getLogger(BatchMsgServiceImpl.class);
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgInfoDao orgInfoDao;

    @Override
    @Transactional(readOnly=true)
    public void sendMediaNews(Integer orgId, String mediaId, Integer groupId) {
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
        log.info("wechat - BatchMsgServiceImpl - sendMediaNews - appdI:{},mediaId:{},groupId:{}", new Object[]{authorizationInfo.getAuthorizerAppId(), mediaId, groupId});
        try {
            BatchMsgApiHelper.sendMediaNews(authorizationInfo.getAuthorizerAccessToken(), mediaId, groupId);
        }
        catch (WechatException e) {
            OrgAccount orgAccount = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, new String[0]);
            log.error("\u5fae\u4fe1\u63d0\u793a: \u9996\u6b21\u4f7f\u7528\u7fa4\u53d1\u529f\u80fd\u524d,\u8bf7\u5148\u767b\u5f55\u5fae\u4fe1\u516c\u4f17\u5e73\u53f0\u5728\u2018\u7fa4\u53d1\u529f\u80fd\u2019\u4e2d\u5b8c\u6210\u534f\u8bae\u786e\u8ba4 orgId:{},name:{},mobile:{}", new Object[]{orgId, orgInfo.getShortName(), orgAccount.getMobile()});
            throw e;
        }
    }
}

