/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.dto.JSSDK;

import com.baijia.tianxiao.sal.wechat.util.JSSDKUtils;
import java.util.Date;
import java.util.UUID;

public class JsSDKParamDto {
    private long timestamp;
    private String nonceStr;
    private String signature;
    private String appId;
    private String accessToken;
    private String jsapiTicker;

    public static JsSDKParamDto generate(String jsapiTicket, String url, String accessToken, String appId) {
        long time = new Date().getTime();
        String randomStr = UUID.randomUUID().toString();
        String shaStrFomat = "jsapi_ticket=%s&noncestr=%s&timestamp=%s&url=%s";
        String shaStr = String.format(shaStrFomat, jsapiTicket, randomStr, time, url);
        String signature = JSSDKUtils.sha1Encrypt(shaStr);
        JsSDKParamDto jspd = new JsSDKParamDto();
        jspd.setAppId(appId);
        jspd.setAccessToken(accessToken);
        jspd.setJsapiTicker(jsapiTicket);
        jspd.setNonceStr(randomStr);
        jspd.setTimestamp(time);
        jspd.setSignature(signature);
        return jspd;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getNonceStr() {
        return this.nonceStr;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getJsapiTicker() {
        return this.jsapiTicker;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setJsapiTicker(String jsapiTicker) {
        this.jsapiTicker = jsapiTicker;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsSDKParamDto)) {
            return false;
        }
        JsSDKParamDto other = (JsSDKParamDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        String this$nonceStr = this.getNonceStr();
        String other$nonceStr = other.getNonceStr();
        if (this$nonceStr == null ? other$nonceStr != null : !this$nonceStr.equals(other$nonceStr)) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        String this$jsapiTicker = this.getJsapiTicker();
        String other$jsapiTicker = other.getJsapiTicker();
        return !(this$jsapiTicker == null ? other$jsapiTicker != null : !this$jsapiTicker.equals(other$jsapiTicker));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JsSDKParamDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        String $nonceStr = this.getNonceStr();
        result = result * 59 + ($nonceStr == null ? 43 : $nonceStr.hashCode());
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        String $jsapiTicker = this.getJsapiTicker();
        result = result * 59 + ($jsapiTicker == null ? 43 : $jsapiTicker.hashCode());
        return result;
    }

    public String toString() {
        return "JsSDKParamDto(timestamp=" + this.getTimestamp() + ", nonceStr=" + this.getNonceStr() + ", signature=" + this.getSignature() + ", appId=" + this.getAppId() + ", accessToken=" + this.getAccessToken() + ", jsapiTicker=" + this.getJsapiTicker() + ")";
    }
}

