/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.model.Message;
import com.baijia.commons.lang.utils.http.HttpClientUtils;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.po.Template;
import com.baijia.tianxiao.dal.callservice.dao.TX400PhoneDao;
import com.baijia.tianxiao.dal.callservice.po.TX400Phone;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgTxtMsgDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncStatus;
import com.baijia.tianxiao.dal.wechat.constant.WechatOpenIdEntityType;
import com.baijia.tianxiao.dal.wechat.constant.WechatPermission;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomActivityDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomMenuDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatOpenIdRecordDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatReplyForKeywordDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatReplyForSubscribeDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatCustomActivity;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatCustomMenu;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForKeyword;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForSubscribe;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.MessageReceiveService;
import com.baijia.tianxiao.sal.wechat.api.ReleaseTest;
import com.baijia.tianxiao.sal.wechat.api.WechatFreeVersionService;
import com.baijia.tianxiao.sal.wechat.api.WechatOpenIdRecordService;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.constant.custommenu.FreeVersionMenuClick;
import com.baijia.tianxiao.sal.wechat.constant.emoticons.WechatEmoticons;
import com.baijia.tianxiao.sal.wechat.constant.qrcode.QRCodeType;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.OrgWechatDto;
import com.baijia.tianxiao.sal.wechat.dto.msgtoapp.MessageDto;
import com.baijia.tianxiao.sal.wechat.dto.org.OrgCenterInfo;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeSceneStr;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeSceneStrActivity;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeSceneStrSubscribeOrg;
import com.baijia.tianxiao.sal.wechat.dto.request.MessageRequest;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.WechatAbstractMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatEventMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatSCANEventMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatSubscribeEventMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatImageMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatOrdinaryMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatTextMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatVoiceMessage;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.AutoReplyHelper;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.KeyWordMatcher;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.PassiveReplyMsgBuilder;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.PassiveReplyMsgHelper;
import com.baijia.tianxiao.sal.wechat.helper.common.WechatCryptUtils;
import com.baijia.tianxiao.sal.wechat.helper.media.WechatMediaApiHelper;
import com.baijia.tianxiao.sal.wechat.helper.menu.WechatMenuJsonConverter;
import com.baijia.tianxiao.sal.wechat.helper.sendmsg.customer.CustomerServiceApiCaller;
import com.baijia.tianxiao.sal.wechat.helper.user.FansServiceApiHelper;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import com.baijia.tianxiao.sal.wechat.util.AudioUtil;
import com.baijia.tianxiao.sal.wechat.util.FileUploadUtils;
import com.baijia.tianxiao.sal.wechat.util.LocalFileHelper;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;
import com.baijia.tianxiao.util.ShortUrlUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MessageReceiveServiceImpl
implements MessageReceiveService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MessageReceiveServiceImpl.class);
    private static final String RELEASE_TEST_USERNAME = "gh_3c884a361561";
    @Autowired
    private ReleaseTest releaseTest;
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private WechatFreeVersionService freeVersionService;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgTxtMsgDao orgTxtMsgDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private OrgWechatReplyForKeywordDao replyForKeywordDao;
    @Autowired
    private OrgWechatReplyForSubscribeDao replySubscribeDao;
    @Autowired
    private OrgWechatCustomMenuDao orgWechatCustomMenuDao;
    @Autowired
    private OrgWechatCustomActivityDao customActivityDao;
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgTeacherDao orgTeacherDao;
    @Autowired
    private OrgWechatOpenIdRecordDao orgWechatOpenIdRecordDao;
    @Autowired
    private TX400PhoneDao tx400PhoneDao;
    @Autowired
    private WechatOpenIdRecordService wechatOpenIdRecordService;
    @Autowired(required=false)
    private CloudAccount cloudAccount;
    private CloudQueue consultMsgQueue;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public String generateDefaultResponse() {
        return "";
    }

    /*
     * Exception decompiling
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public String handle(MessageRequest request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String generateEventResponse(WechatEventMessage message) {
        switch (message.getEvent()) {
            case SUBSCRIBE: {
                WechatSubscribeEventMessage subscribeMsg = (WechatSubscribeEventMessage)message;
                AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(subscribeMsg.getToUserName());
                if (authorizerInfo == null || !authorizerInfo.isPassedVerify()) {
                    return this.generateDefaultResponse();
                }
                if (StringUtils.isNotBlank((CharSequence)subscribeMsg.getTicket())) {
                    String params = subscribeMsg.getEventKey();
                    QRCodeType qwCodeType = QRCodeSceneStr.parseQRCodeType(params);
                    log.info("***************** A " + (Object)((Object)qwCodeType));
                    if (qwCodeType != null) {
                        switch (qwCodeType) {
                            case CUSTOM_ACTIVITY: {
                                log.info("***************** A111 " + (Object)((Object)qwCodeType));
                                QRCodeSceneStrActivity dto = QRCodeSceneStrActivity.fromSceneStr(params);
                                OrgWechatCustomActivity customActivity = this.customActivityDao.get(dto.getActivityId().intValue(), dto.getActivityType().intValue());
                                Template template = this.templateDao.selectTemplateById(dto.getActivityType());
                                String relativePath = template != null ? template.getUrl() : null;
                                String webauthUrl = WechatWebAuthLinkBuilder.customActivity(WebAuthScope.BASE, authorizerInfo.getAuthorizerAppId(), customActivity.getActivityId(), customActivity.getActivityType(), relativePath);
                                return PassiveReplyMsgBuilder.newsMsg(message.getToUserName(), message.getFromUserName(), customActivity.getTitle(), customActivity.getDescription(), customActivity.getPicUrl(), webauthUrl);
                            }
                            case SUBCRIBE_WITH_ORG_ID: {
                                QRCodeSceneStrSubscribeOrg dto1 = QRCodeSceneStrSubscribeOrg.fromSceneStr(params);
                                String freeVersionCheck = this.orgIdQrCodeReply4FreeVersion(authorizerInfo, message, dto1.getOrgId());
                                if (freeVersionCheck == null) break;
                                return freeVersionCheck;
                            }
                        }
                    } else {
                        log.warn("wechat QRCodeType is null - params:{}", (Object)params);
                    }
                }
                OrgWechatReplyForSubscribe reply = this.replySubscribeDao.getByAppId(authorizerInfo.getAuthorizerAppId());
                String replyContent = PassiveReplyMsgHelper.getSubscribeReply(subscribeMsg.getToUserName(), subscribeMsg.getFromUserName(), reply);
                if (reply != null && !replyContent.equals("success")) {
                    AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
                    try {
                        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MSG_CUSTOMER_SERVICE);
                        AutoReplyHelper.sendSubscribeReply(authorizationInfo.getAuthorizerAccessToken(), subscribeMsg.getFromUserName(), reply);
                        break;
                    }
                    catch (Exception e) {
                        return replyContent;
                    }
                }
                return this.getDefaultSubscribeReply(subscribeMsg, authorizerInfo);
            }
            case UNSUBSCRIBE: {
                break;
            }
            case SCAN: {
                WechatSCANEventMessage scanMsg = (WechatSCANEventMessage)message;
                AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(scanMsg.getToUserName());
                if (authorizerInfo == null || !authorizerInfo.isPassedVerify()) {
                    return this.generateDefaultResponse();
                }
                if (!StringUtils.isNotBlank((CharSequence)scanMsg.getTicket())) break;
                String params = scanMsg.getEventKey();
                QRCodeType qwCodeType = QRCodeSceneStr.parseQRCodeType(params);
                if (qwCodeType != null) {
                    switch (qwCodeType) {
                        case CUSTOM_ACTIVITY: {
                            QRCodeSceneStrActivity dto = QRCodeSceneStrActivity.fromSceneStr(params);
                            OrgWechatCustomActivity customActivity = this.customActivityDao.get(dto.getActivityId().intValue(), dto.getActivityType().intValue());
                            Template template = this.templateDao.selectTemplateById(dto.getActivityType());
                            String relativePath = template != null ? template.getUrl() : null;
                            String webauthUrl = WechatWebAuthLinkBuilder.customActivity(WebAuthScope.BASE, authorizerInfo.getAuthorizerAppId(), customActivity.getActivityId(), customActivity.getActivityType(), relativePath);
                            return PassiveReplyMsgBuilder.newsMsg(message.getToUserName(), message.getFromUserName(), customActivity.getTitle(), customActivity.getDescription(), customActivity.getPicUrl(), webauthUrl);
                        }
                        case SUBCRIBE_WITH_ORG_ID: {
                            QRCodeSceneStrSubscribeOrg dto1 = QRCodeSceneStrSubscribeOrg.fromSceneStr(params);
                            String freeVersionCheck = this.orgIdQrCodeReply4FreeVersion(authorizerInfo, message, dto1.getOrgId());
                            if (freeVersionCheck == null) break;
                            return freeVersionCheck;
                        }
                    }
                    break;
                }
                log.warn("wechat - unknow qwCodeType - params:{}", (Object)params);
                break;
            }
            case LOCATION: {
                break;
            }
            case MENU_CLICK: {
                AuthorizationInfo authorizationInfo;
                String content;
                Map<String, String> keyVsContentMap;
                AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
                this.sendMenuVisitMonitor(authorizerInfo, message.getFromUserName());
                if (authorizerInfo == null || !authorizerInfo.isPassedVerify()) {
                    return this.generateDefaultResponse();
                }
                String freeVersionCheck = this.menuClick4FreeVersion(authorizerInfo, message);
                if (freeVersionCheck != null) {
                    return freeVersionCheck;
                }
                OrgWechatCustomMenu menu = this.orgWechatCustomMenuDao.getByAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
                if (menu == null || (keyVsContentMap = WechatMenuJsonConverter.mapClickKeyVsContent(menu.getJson())) == null || keyVsContentMap.isEmpty() || !StringUtils.isNotBlank((CharSequence)(content = keyVsContentMap.get(message.getEventKey()))) || (authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId())) == null) break;
                CustomerServiceApiCaller.sendTextMsg(authorizationInfo.getAuthorizerAccessToken(), message.getFromUserName(), content);
                break;
            }
            case MENU_VIEW: {
                AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
                this.sendMenuVisitMonitor(authorizerInfo, message.getFromUserName());
                break;
            }
            case UNKNOWN: {
                log.warn("wechat - receive unknown event message - message:{}", (Object)message);
            }
        }
        return this.generateDefaultResponse();
    }

    String getDefaultSubscribeReply(WechatSubscribeEventMessage message, AuthorizerInfo authorizerInfo) {
        TX400Phone tx400Phone;
        if (this.freeVersionService.isFreeAccount(authorizerInfo.getAuthorizerAppId())) {
            StringBuilder content = new StringBuilder();
            content.append("\u6b22\u8fce\u5173\u6ce8" + authorizerInfo.getNickName() + "\uff01\n");
            content.append("\u6dfb\u52a0\u673a\u6784\u540e\uff0c\u4f60\u53ef\u4ee5\u5728\u7ebf\u8054\u7cfb\u673a\u6784\uff0c\u5728\u4e2a\u4eba\u4e2d\u5fc3\u67e5\u770b\u81ea\u5df1\u7684\u8bfe\u7a0b\u53ca\u7b7e\u5230\u60c5\u51b5\u7b49\u4fe1\u606f\u54e6\uff01\n");
            content.append("\u5982\u4f55\u6dfb\u52a0\u673a\u6784\uff1f\n");
            content.append("\u626b\u63cf\u673a\u6784\u7684\u4e8c\u7ef4\u7801\uff0c\u6216\u8005\u76f4\u63a5\u5728\u5bf9\u8bdd\u6846\u4e2d\u8f93\u5165\u673a\u6784\u7684\u5929\u6821\u53f7\u5c31\u53ef\u4ee5\u4e86\uff01");
            return PassiveReplyMsgBuilder.textMsg(message.getToUserName(), message.getFromUserName(), content.toString());
        }
        Integer orgId = authorizerInfo.getOrgId();
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, new String[0]);
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        OrgWechatDto owDto = new OrgWechatDto(orgId, orgAccount.getNumber(), authorizerInfo.getAuthorizerAppId());
        StringBuilder content = new StringBuilder();
        content.append("\u81f4\u4eb2\u7231\u7684\u4f60\uff1a\n\n");
        content.append("\u6b22\u8fce\u52a0\u5165").append(orgInfo.getShortName()).append("\u5927\u5bb6\u5ead!").append("\n\n");
        content.append(this.getHrefLink(MediaType.WANGXIAOZHUYE.getUrl(owDto), orgInfo.getShortName() + "\u5fae\u5b98\u7f51\u6b63\u5f0f\u4e0a\u7ebf\u5566!\u8fdb\u6765\u770b\u770b\u6709\u60ca\u559c\u54e6!")).append("\n\n");
        content.append("\u73b0\u5728\u9884\u7ea6\u4f53\u9a8c\u8bfe\uff0c\u83b7\u8c6a\u534e\u5927\u793c\u5305\uff08\u4ec5\u9650\u9996\u6b21\u9884\u7ea6\u7528\u6237\uff09\uff0c\u8fd8\u5728\u7b49\u4ec0\u4e48\uff0c\u70b9\u51fb").append(this.getHrefLink(MediaType.YUYUESHITING.getUrl(owDto), "\u9884\u7ea6\u8bd5\u542c")).append("!").append("\n\n");
        content.append("\u54a8\u8be2\u8bfe\u7a0b\uff1f\u6b22\u8fce\u7559\u4e0b\u60a8\u7684\u59d3\u540d\u3001\u8054\u7cfb\u65b9\u5f0f\uff0c\u6211\u4eec\u4f1a\u6709\u4e13\u4e1a\u7684\u8001\u5e08\u5e2e\u60a8\u8be6\u7ec6\u89e3\u7b54\u3002").append("\n\n");
        if (authorizerInfo.hasWebAuthPermission()) {
            content.append("\u60f3\u5feb\u901f\u67e5\u8bfe\u8868\u3001\u5199\u8bc4\u4ef7\u3001\u770b\u4e0a\u8bfe\u8bb0\u5f55\uff1f\u4e0d\u8bba\u662f\u5b66\u751f\u8fd8\u662f\u8001\u5e08\uff0c\u53ef\u5728\u201c").append(this.getHrefLink(MediaType.XUESHENGZHONGXIN.getUrl(owDto), "\u5b66\u751f\u4e2d\u5fc3")).append("/").append(this.getHrefLink(MediaType.LAOSHIZHONGXIN.getUrl(owDto), "\u8001\u5e08\u4e2d\u5fc3")).append("\u201d\u8f7b\u677e\u5b8c\u6210\uff0c\u9a6c\u4e0a\u8fdb\u884c\u8eab\u4efd\u9a8c\u8bc1\u5427\u3002").append("\n\n");
        }
        if ((tx400Phone = this.tx400PhoneDao.getByOrgId(orgId)) != null && !Flag.getBoolean((Integer)tx400Phone.getIsdel())) {
            content.append("\u6709\u8bdd\u5bf9\u6211\u4eec\u8bf4\uff1f\u6b22\u8fce\u6253\u7535\u8bdd\u7ed9\u6211\u4eec\u54df~ ").append(tx400Phone.getPhone400()).append(" \uff0c\u6211\u4eec\u5c06\u6089\u5fc3\u8046\u542c\uff0c\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1\u3002").append("\n\n");
        } else {
            content.append("\u6709\u8bdd\u5bf9\u6211\u4eec\u8bf4\uff1f\u6b22\u8fce\u6253\u7535\u8bdd\u7ed9\u6211\u4eec\u54df~ ").append(WechatProperties.getMobileNumber400Main() + "\u8f6c" + orgInfo.getExtension()).append(" \uff0c\u6211\u4eec\u5c06\u6089\u5fc3\u8046\u542c\uff0c\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1\u3002").append("\n\n");
        }
        content.append("\u7cbe\u5f69\u6d3b\u52a8\uff0c\u656c\u8bf7\u5173\u6ce8\uff01").append("\n\n");
        return PassiveReplyMsgBuilder.textMsg(message.getToUserName(), message.getFromUserName(), content.toString());
    }

    String getHrefLink(String href, String content) {
        String link = "<a href=\"%s\">%s</a>";
        return String.format(link, href, content);
    }

    void sendMenuVisitMonitor(AuthorizerInfo authorizerInfo, String openId) {
        if (authorizerInfo == null || StringUtils.isBlank((CharSequence)openId)) {
            return;
        }
        try {
            OrgAccount orgAccount = this.orgAccountDao.getAccountById(authorizerInfo.getOrgId().intValue(), new String[0]);
            String url = WechatProperties.getWebCRMUrlPrefix() + "monitor.do";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("orgNumber", orgAccount.getNumber() + "");
            params.put("userNumber", openId);
            params.put("typeNumber", "10");
            HttpClientUtils.doGet((String)url, params);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String generateOrdinaryResponse(WechatOrdinaryMessage message) throws WechatException, WebServiceException, Exception {
        switch (message.getMsgType()) {
            case TEXT: {
                return this.generateTextOrdinaryResponse((WechatTextMessage)message);
            }
            case IMAGE: {
                return this.generateImageOrdinaryResponse((WechatImageMessage)message);
            }
            case VOICE: {
                return this.generateVoiceOrdinaryResponse((WechatVoiceMessage)message);
            }
            case VIDEO: {
                break;
            }
            case SHORT_VIDEO: {
                break;
            }
            case LOCATION: {
                break;
            }
            case LINK: {
                break;
            }
            case UNKNOWN: {
                log.warn("wechat - receive unknown type message - message:{}", (Object)message);
                break;
            }
        }
        return this.generateDefaultResponse();
    }

    private String generateTextOrdinaryResponse(WechatTextMessage message) {
        String keywordReply;
        log.info("\u666e\u901a\u6d88\u606f-\u6587\u672c {} ", (Object)message);
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
        if (authorizerInfo == null) {
            return this.generateDefaultResponse();
        }
        Fans fans = this.fansDao.getByOpenId(message.getFromUserName());
        String freeVersionCheck = this.txNumerReply4FreeVersion(authorizerInfo, message);
        if (freeVersionCheck != null) {
            return freeVersionCheck;
        }
        if (fans != null) {
            MessageDto dto = new MessageDto(MsgType.TEXT.getValue(), DateUtil.date2UnixTimestamp((Date)message.getCreateTime()), authorizerInfo.getOrgId(), authorizerInfo.getAuthorizerAppId(), message.getFromUserName(), fans.getShowName(), fans.getHeadImgUrl());
            dto.setTextContent(WechatEmoticons.convert(message.getContent()));
            String msg = MessageSource.WECHAT.buildConsultTypeMsg(dto.toJsonStr());
            try {
                this.consultMsgQueue.putMessage(new Message(msg));
                log.info("put message to consultMsgQueue msg:{}", (Object)msg);
            }
            catch (Exception e) {
                log.info("put message to consultMsgQueue - Exception - msg:{},e:{}", (Object)msg, (Object)e);
            }
        }
        if ((keywordReply = this.getKeywordReply(message, authorizerInfo)) != null) {
            return keywordReply;
        }
        return this.generateDefaultResponse();
    }

    String getKeywordReply(WechatTextMessage message, AuthorizerInfo authorizerInfo) {
        List replyList = this.replyForKeywordDao.search(authorizerInfo.getAuthorizerAppId(), null);
        OrgWechatReplyForKeyword reply = KeyWordMatcher.match(message.getContent(), replyList);
        if (reply != null) {
            AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
            try {
                WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MSG_CUSTOMER_SERVICE);
                AutoReplyHelper.sendKeywordReply(authorizationInfo.getAuthorizerAccessToken(), message.getFromUserName(), reply);
            }
            catch (Exception e) {
                return PassiveReplyMsgHelper.getKeywordReply(message.getToUserName(), message.getFromUserName(), reply);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String generateImageOrdinaryResponse(WechatImageMessage message) throws WechatException, WebServiceException, Exception {
        fans = this.fansDao.getByOpenId(message.getFromUserName());
        if (fans == null) {
            return this.generateDefaultResponse();
        }
        authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
        if (this.freeVersionService.isFreeAccount(authorizerInfo.getAuthorizerAppId())) {
            return this.generateDefaultResponse();
        }
        authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
        if (authorizationInfo == null) {
            return this.generateDefaultResponse();
        }
        uid = Long.parseLong(authorizerInfo.getOrgId() + "");
        localFile = null;
        try {
            data = WechatMediaApiHelper.downloadTempMedia(authorizationInfo.getAuthorizerAccessToken(), message.getMediaId());
            localFile = LocalFileHelper.saveToLocal(data, MIMEType.JPG);
            result = FileUploadUtils.uploadToRemote(uid, localFile, false);
            storageId = this.saveToDb(result, MIMEType.JPG);
            orgStorage = this.orgStorageDao.getById(storageId.intValue());
            image = ImageIO.read(localFile);
            imageWidth = image.getWidth();
            imageHeight = image.getHeight();
            ** if (localFile == null) goto lbl-1000
        }
        catch (Exception e) {
            block11: {
                try {
                    MessageReceiveServiceImpl.log.error("wechat - generateImageOrdinaryResponse - exception", (Throwable)e);
                    result = this.generateDefaultResponse();
                    if (localFile == null) break block11;
                }
                catch (Throwable var14_17) {
                    if (localFile != null) {
                        LocalFileHelper.deleteFile(localFile);
                    }
                    throw var14_17;
                }
                LocalFileHelper.deleteFile(localFile);
            }
            return result;
        }
lbl-1000:
        // 1 sources

        {
            LocalFileHelper.deleteFile(localFile);
        }
lbl-1000:
        // 2 sources

        {
        }
        dto = new MessageDto(MsgType.PICTURE.getValue(), DateUtil.date2UnixTimestamp((Date)message.getCreateTime()), authorizerInfo.getOrgId(), authorizerInfo.getAuthorizerAppId(), message.getFromUserName(), fans.getShowName(), fans.getHeadImgUrl());
        dto.setImageContent(storageId, StorageUtil.constructUrl(orgStorage), imageHeight, imageWidth);
        msg = MessageSource.WECHAT.buildConsultTypeMsg(dto.toJson().toString());
        try {
            this.consultMsgQueue.putMessage(new Message(msg));
            MessageReceiveServiceImpl.log.info("put message to consultMsgQueue msg:{}", (Object)msg);
        }
        catch (Exception e) {
            MessageReceiveServiceImpl.log.info("put message to consultMsgQueue - Exception - msg:{},e:{}", (Object)msg, (Object)e);
        }
        return this.generateDefaultResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String generateVoiceOrdinaryResponse(WechatVoiceMessage message) throws WechatException, WebServiceException, Exception {
        fans = this.fansDao.getByOpenId(message.getFromUserName());
        if (fans == null) {
            return this.generateDefaultResponse();
        }
        if (StringUtils.isNotBlank((CharSequence)message.getRecognition())) {
            textMessage = new WechatTextMessage("[\u8bed\u97f3\u8bc6\u522b] " + message.getRecognition());
            textMessage.setCreateTime(message.getCreateTime());
            textMessage.setFromUserName(message.getFromUserName());
            textMessage.setMsgId(message.getMsgId());
            textMessage.setMsgType(message.getMsgType());
            textMessage.setToUserName(message.getToUserName());
            return this.generateTextOrdinaryResponse(textMessage);
        }
        if (!message.getFormat().toLowerCase().equals("amr")) {
            textMessage = new WechatTextMessage("[\u4e0d\u652f\u6301\u7684\u8bed\u97f3\u7c7b\u578b] " + message.getFormat().toLowerCase());
            textMessage.setCreateTime(message.getCreateTime());
            textMessage.setFromUserName(message.getFromUserName());
            textMessage.setMsgId(message.getMsgId());
            textMessage.setMsgType(message.getMsgType());
            textMessage.setToUserName(message.getToUserName());
            return this.generateTextOrdinaryResponse(textMessage);
        }
        authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
        if (this.freeVersionService.isFreeAccount(authorizerInfo.getAuthorizerAppId())) {
            return this.generateDefaultResponse();
        }
        authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
        uid = Long.parseLong(authorizerInfo.getOrgId() + "");
        localFile = null;
        try {
            data = WechatMediaApiHelper.downloadTempMedia(authorizationInfo.getAuthorizerAccessToken(), message.getMediaId());
            localFile = LocalFileHelper.saveToLocal(data, MIMEType.AMR);
            result = FileUploadUtils.uploadToRemote(uid, localFile, false);
            storageId = this.saveToDb(result, MIMEType.AMR);
            orgStorage = this.orgStorageDao.getById(storageId.intValue());
            voiceLength = Integer.parseInt(AudioUtil.getAmrDuration(localFile) + "");
            ** if (localFile == null) goto lbl-1000
        }
        catch (Exception e) {
            block12: {
                try {
                    MessageReceiveServiceImpl.log.error("wechat - generateVoiceOrdinaryResponse - exception", (Throwable)e);
                    result = this.generateDefaultResponse();
                    if (localFile == null) break block12;
                }
                catch (Throwable var12_16) {
                    if (localFile != null) {
                        LocalFileHelper.deleteFile(localFile);
                    }
                    throw var12_16;
                }
                LocalFileHelper.deleteFile(localFile);
            }
            return result;
        }
lbl-1000:
        // 1 sources

        {
            LocalFileHelper.deleteFile(localFile);
        }
lbl-1000:
        // 2 sources

        {
        }
        dto = new MessageDto(MsgType.VOICE.getValue(), DateUtil.date2UnixTimestamp((Date)message.getCreateTime()), authorizerInfo.getOrgId(), authorizerInfo.getAuthorizerAppId(), message.getFromUserName(), fans.getShowName(), fans.getHeadImgUrl());
        dto.setVoiceContent(storageId, StorageUtil.constructUrl(orgStorage), voiceLength);
        msg = MessageSource.WECHAT.buildConsultTypeMsg(dto.toJson().toString());
        try {
            this.consultMsgQueue.putMessage(new Message(msg));
            MessageReceiveServiceImpl.log.info("put message to consultMsgQueue msg:{}", (Object)msg);
        }
        catch (Exception e) {
            MessageReceiveServiceImpl.log.info("put message to consultMsgQueue - Exception - msg:{},e:{}", (Object)msg, (Object)e);
        }
        return this.generateDefaultResponse();
    }

    private String generateSubscribeEventResponse(WechatSubscribeEventMessage message) {
        try {
            AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(authorizerInfo.getOrgId(), new String[0]);
            OrgTxtMsg brief = this.orgTxtMsgDao.getOrgTxtByIdAndType(authorizerInfo.getOrgId().intValue(), 3101);
            StringBuilder msg = new StringBuilder();
            String intro = "";
            if (brief != null && StringUtils.isNotBlank((CharSequence)brief.getValue())) {
                intro = brief.getValue();
            }
            msg.append("\u611f\u8c22\u5173\u6ce8\u3010").append(orgInfo.getShortName()).append("\u3011\u3002").append(intro);
            String content = msg.toString();
            String response = WechatCryptUtils.encryptMsg(message.getFromUserName(), message.getToUserName(), "text", content);
            log.info("wechat - return subscribe event response:{}", (Object)response);
            return response;
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private Integer saveToDb(UploadResult uploadResult, MIMEType mimeType) {
        List uploadFiles = uploadResult.getFiles();
        if (uploadFiles.size() == 0) {
            return 0;
        }
        UploadResult.UploadFile uploadFile = (UploadResult.UploadFile)uploadFiles.get(0);
        OrgStorage orgStorage = new OrgStorage();
        orgStorage.setFid(uploadFile.getFid());
        orgStorage.setSn(uploadFile.getSn());
        orgStorage.setSize(Integer.valueOf(uploadFile.getSize()));
        orgStorage.setMimeType(Integer.valueOf(mimeType.getCode()));
        Date now = new Date();
        orgStorage.setCreateTime(now);
        orgStorage.setUpdateTime(now);
        orgStorage.setIsDel(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        orgStorage.setSource(Short.valueOf((short)0));
        this.orgStorageDao.save((Object)orgStorage, Boolean.valueOf(true), new String[0]);
        return orgStorage.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirstTimeHandle(String key) {
        log.info("Wechat - isFirstTimeHandle - check - key:{}", (Object)key);
        RedisConnection connection = this.redisTemplate.getConnectionFactory().getConnection();
        try {
            connection.select(WechatProperties.getRedisDB().intValue());
            if (connection.exists(key.getBytes()).booleanValue()) {
                boolean bl = false;
                return bl;
            }
            connection.setEx(key.getBytes(), 20L, "".getBytes());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("Wechat - isFirstTimeHandle - exception - e:{}", (Throwable)e);
            boolean bl = true;
            return bl;
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        }
    }

    public Fans fansPretreatment(WechatAbstractMessage message) {
        Fans fans = null;
        fans = this.fansDao.getByOpenId(message.getFromUserName());
        if (fans == null) {
            AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
            if (authorizerInfo == null || !authorizerInfo.isPassedVerify() || authorizerInfo.getFansSyncStatus().intValue() == WechatDataSyncStatus.ONGOING.getValue()) {
                return null;
            }
            AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
            if (authorizationInfo == null || !authorizationInfo.hasFunc(Integer.valueOf(WechatPermission.USER_MANAGE.getValue()))) {
                return null;
            }
            try {
                fans = FansServiceApiHelper.getFansInfo(authorizationInfo.getAuthorizerAccessToken(), message.getFromUserName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fans == null) {
                return null;
            }
            fans.initBasicAttribute();
            if (message instanceof WechatOrdinaryMessage) {
                fans.setLastCommunicationTime(new Date());
            } else {
                fans.setLastCommunicationTime(new Date(0L));
            }
            fans.setAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
            if (StringUtils.isNotBlank((CharSequence)fans.getHeadImgUrl())) {
                try {
                    MIMEType mime = MIMEType.JPG;
                    UploadResult result = FileUploadUtils.uploadToRemote(0L, fans.getHeadImgUrl(), MIMEType.JPG, false);
                    UploadResult.UploadFile uploadFile = (UploadResult.UploadFile)result.getFiles().get(0);
                    this.saveToDb(result, mime);
                    String headImgUrlGsx = StorageUtil.constructUrl(uploadFile.getFid(), uploadFile.getSn(), mime.getCode());
                    fans.setHeadImgUrlGsx(headImgUrlGsx);
                }
                catch (Exception e) {
                    log.warn("fansPretreatment - headImgUrlGsx - exception:{}", (Throwable)e);
                }
            } else {
                fans.setHeadImgUrlGsx("");
            }
            try {
                this.fansDao.save((Object)fans, Boolean.valueOf(true), new String[0]);
            }
            catch (DuplicateKeyException ce) {
                fans = this.fansDao.getByOpenId(message.getFromUserName());
            }
            log.info("wechat - MessageReceiveServiceImpl - save fans - fans:{}", (Object)fans);
        } else if (message instanceof WechatOrdinaryMessage) {
            fans.setLastCommunicationTime(new Date());
            fans.setSubscribe(Integer.valueOf(1));
            log.info("wechat - MessageReceiveServiceImpl - WechatOrdinaryMessage - update fans - fans:{}", (Object)fans);
            this.fansDao.update((Object)fans, Boolean.valueOf(true), new String[0]);
        } else if (message instanceof WechatEventMessage) {
            switch (((WechatEventMessage)message).getEvent()) {
                case SUBSCRIBE: {
                    if (fans.getSubscribe() == 1) break;
                    fans.setSubscribe(Integer.valueOf(1));
                    fans.setSubscribeTime(new Date());
                    log.info("wechat - MessageReceiveServiceImpl - SUBSCRIBE - update fans - fans:{}", (Object)fans);
                    this.fansDao.update((Object)fans, Boolean.valueOf(true), new String[0]);
                    break;
                }
                case UNSUBSCRIBE: {
                    fans.setSubscribe(Integer.valueOf(0));
                    log.info("wechat - MessageReceiveServiceImpl - UNSUBSCRIBE - update fans - fans:{}", (Object)fans);
                    this.fansDao.update((Object)fans, Boolean.valueOf(true), new String[0]);
                    break;
                }
            }
        }
        return fans;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            Properties mnsProperties = PropertiesReader.getProperties((String)"mns.properties");
            CloudAccount cloudAccount = new CloudAccount(mnsProperties.getProperty("mns.accesskeyid"), mnsProperties.getProperty("mns.accesskeysecret"), mnsProperties.getProperty("mns.accountendpoint"));
            this.consultMsgQueue = cloudAccount.getMNSClient().getQueueRef(mnsProperties.getProperty("consult.msg.queue"));
        }
        catch (Exception e) {
            log.error("init cloud account error.");
        }
    }

    @Override
    public void pushConsultation(String orgNumber, String openId) {
    }

    String menuClick4FreeVersion(AuthorizerInfo authorizerInfo, WechatEventMessage message) {
        if (this.freeVersionService.isFreeAccount(authorizerInfo.getAuthorizerAppId())) {
            FreeVersionMenuClick obj = FreeVersionMenuClick.getByKey(message.getEventKey());
            if (obj == null) {
                log.error("freeVersion unknown click key");
                return null;
            }
            List<Object> orgIds = new ArrayList();
            StringBuilder reply = new StringBuilder();
            WechatOpenIdEntityType entityType = null;
            switch (obj) {
                case STUDNET_CENTER: {
                    orgIds = this.wechatOpenIdRecordService.listOrgIdBy(authorizerInfo.getAuthorizerAppId(), message.getFromUserName(), WechatOpenIdEntityType.STUDENT);
                    entityType = WechatOpenIdEntityType.STUDENT;
                    break;
                }
                case TEACHER_CENTER: {
                    orgIds = this.wechatOpenIdRecordService.listOrgIdBy(authorizerInfo.getAuthorizerAppId(), message.getFromUserName(), WechatOpenIdEntityType.TEACHER);
                    entityType = WechatOpenIdEntityType.TEACHER;
                }
            }
            ArrayList<Integer> orgIdsInteger = new ArrayList<Integer>();
            for (Long longId : orgIds) {
                if (this.authorizationInfoDao.getByOrgId(Integer.valueOf(longId.intValue())) != null) continue;
                orgIdsInteger.add(longId.intValue());
            }
            if (CollectionUtils.isEmpty(orgIdsInteger)) {
                reply.append("\u4f60\u8fd8\u6ca1\u6709\u7ed1\u5b9a\u7684\u673a\u6784\u54e6\uff01\u53ef\u4ee5\u901a\u8fc7\u4ee5\u4e0b\u65b9\u5f0f\u7ed1\u5b9a\u673a\u6784\uff1a").append("\n").append("\u626b\u63cf\u673a\u6784\u7684\u4e8c\u7ef4\u7801\uff0c\u6216\u76f4\u63a5\u5728\u5bf9\u8bdd\u6846\u4e2d\u8f93\u5165\u673a\u6784\u7684\u5929\u6821\u53f7\u5c31\u53ef\u4ee5\u4e86\uff01");
            } else {
                List orgInfos = this.orgInfoDao.getOrgInfos(orgIdsInteger, new String[0]);
                List<OrgCenterInfo> list = OrgCenterInfo.convertBy(authorizerInfo.getAuthorizerAppId(), orgInfos, entityType);
                if (CollectionUtils.isNotEmpty(list)) {
                    reply.append("\u60f3\u8981\u67e5\u770b\u54ea\u4e2a\u673a\u6784,\u70b9\u51fb\u673a\u6784\u540d\u79f0\u76f4\u63a5\u8bbf\u95ee");
                }
                boolean useShortUrl = false;
                String url = null;
                if (list.size() > 1) {
                    useShortUrl = true;
                }
                for (OrgCenterInfo cInfo : list) {
                    url = useShortUrl ? ShortUrlUtil.getShortUrl((String)cInfo.getUrl()) : cInfo.getUrl();
                    reply.append("\n\n").append(this.getHrefLink(url, cInfo.getOrgShortName()));
                }
            }
            return PassiveReplyMsgBuilder.textMsg(message.getToUserName(), message.getFromUserName(), reply.toString());
        }
        return null;
    }

    String txNumerReply4FreeVersion(AuthorizerInfo authorizerInfo, WechatTextMessage message) {
        if (this.freeVersionService.isFreeAccount(authorizerInfo.getAuthorizerAppId())) {
            String keywordReply = this.getKeywordReply(message, authorizerInfo);
            if (keywordReply != null) {
                return keywordReply;
            }
            if (!message.getContent().contains("\\.") && NumberUtils.isNumber((String)message.getContent())) {
                OrgInfo orgInfo = this.orgInfoDao.getByExtension(message.getContent(), new String[0]);
                if (orgInfo != null && this.freeVersionService.isFreeAccount(orgInfo.getOrgId())) {
                    OrgAccount org = (OrgAccount)this.orgAccountDao.getById((Serializable)orgInfo.getOrgId(), new String[0]);
                    String url = OrgCenterInfo.getCenterSelectUrl(org.getId().longValue(), authorizerInfo.getAuthorizerAppId());
                    return PassiveReplyMsgBuilder.newsMsg(message.getToUserName(), message.getFromUserName(), orgInfo.getShortName() + ": \u9700\u8981\u60a8\u5b8c\u5584\u4e00\u4e0b\u4fe1\u606f\u54e6!", "", WechatProperties.getOrgCenterImg(), url);
                }
                return PassiveReplyMsgBuilder.textMsg(message.getToUserName(), message.getFromUserName(), "\u673a\u6784\u4e0d\u5b58\u5728\u3002 \u8bf7\u6838\u5bf9\u673a\u6784\u5929\u6821\u53f7\u540e\u91cd\u65b0\u8f93\u5165,\u6216\u626b\u7801\u5173\u6ce8\u3002");
            }
            return this.generateDefaultResponse();
        }
        return null;
    }

    String orgIdQrCodeReply4FreeVersion(AuthorizerInfo authorizerInfo, WechatEventMessage message, Integer orgId) {
        if (this.freeVersionService.isFreeAccount(authorizerInfo.getAuthorizerAppId())) {
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, new String[0]);
            if (orgInfo != null && this.freeVersionService.isFreeAccount(orgInfo.getOrgId())) {
                OrgAccount org = (OrgAccount)this.orgAccountDao.getById((Serializable)orgInfo.getOrgId(), new String[0]);
                String url = OrgCenterInfo.getCenterSelectUrl(org.getId().longValue(), authorizerInfo.getAuthorizerAppId());
                return PassiveReplyMsgBuilder.newsMsg(message.getToUserName(), message.getFromUserName(), orgInfo.getShortName() + ": \u9700\u8981\u60a8\u5b8c\u5584\u4e00\u4e0b\u4fe1\u606f\u54e6!", "", WechatProperties.getOrgCenterImg(), url);
            }
            return PassiveReplyMsgBuilder.textMsg(message.getToUserName(), message.getFromUserName(), "\u673a\u6784\u4e0d\u5b58\u5728\u3002 \u8bf7\u6838\u5bf9\u673a\u6784\u5929\u6821\u53f7\u540e\u91cd\u65b0\u8f93\u5165,\u6216\u626b\u7801\u5173\u6ce8\u3002");
        }
        return null;
    }
}

