/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.activity.constants.TemplateConstant;
import com.baijia.tianxiao.dal.activity.dao.ActivityWechatReplaceDao;
import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.po.ActivityWechatReplace;
import com.baijia.tianxiao.dal.activity.po.Template;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomActivityDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatCustomActivity;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForKeyword;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.api.AutoReplyService;
import com.baijia.tianxiao.sal.wechat.api.CustomActivityService;
import com.baijia.tianxiao.sal.wechat.api.WechatFreeVersionService;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.dto.customactivity.CustomActivityDto;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeDto;
import com.baijia.tianxiao.sal.wechat.helper.qrcode.WechatQRCodeLinkHelper;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;
import com.baijia.tianxiao.util.ShortUrlUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomActivityServiceImpl
implements CustomActivityService {
    private static final Logger log = LoggerFactory.getLogger(CustomActivityServiceImpl.class);
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private OrgWechatCustomActivityDao customActivityDao;
    @Autowired
    private AuthorizerInfoService authorizerInfoService;
    @Autowired
    private AutoReplyService autoReplyService;
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private ActivityWechatReplaceDao activityWechatReplaceDao;
    @Autowired
    private WechatFreeVersionService wechatFreeVersionService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CustomActivityDto createCustomActivity(int orgId, int activityId, int activityType, String title, String description, String picUrl) throws Exception {
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
        QRCodeDto qrCodeDto = WechatQRCodeLinkHelper.getQRCodeDtoForCustomActivity(authorizationInfo.getAuthorizerAccessToken(), activityId, activityType);
        String qrCodeImgUrl = WechatQRCodeLinkHelper.getGsxImgUrl(qrCodeDto);
        OrgWechatCustomActivity customActivity = new OrgWechatCustomActivity();
        customActivity.setAuthorizerAppId(authorizationInfo.getAuthorizerAppId());
        customActivity.setActivityType(Integer.valueOf(activityType));
        customActivity.setActivityId(Integer.valueOf(activityId));
        customActivity.setQrCodeUrl(qrCodeImgUrl);
        customActivity.setTitle(title);
        customActivity.setDescription(description);
        customActivity.setPicUrl(picUrl);
        customActivity.setCreateTime(new Date());
        try {
            this.customActivityDao.save((Object)customActivity, Boolean.valueOf(true), new String[0]);
            log.info("wechat - CustomActivityServiceImpl - createCustomActivity - obj:{}", (Object)customActivity);
        }
        catch (Exception e) {
            log.error("wechat - CustomActivityServiceImpl - createCustomActivity - exception - obj:{}", (Object)customActivity);
            throw e;
        }
        String relativePath = TemplateConstant.getTemplateUrl((Integer)activityType);
        CustomActivityDto dto = new CustomActivityDto();
        dto.setActivityId(activityId);
        dto.setActivityType(activityType);
        dto.setAuthorizerAppId(authorizationInfo.getAuthorizerAppId());
        dto.setQrCodeUrl(qrCodeImgUrl);
        dto.setWebAuthUrl(WechatWebAuthLinkBuilder.customActivity(WebAuthScope.BASE, authorizationInfo.getAuthorizerAppId(), activityId, activityType, relativePath));
        return dto;
    }

    @Override
    @Transactional(readOnly=true)
    public CustomActivityDto getCustomActivity(int activityId, int activityType) {
        OrgWechatCustomActivity customActivity = this.customActivityDao.get(activityId, activityType);
        log.info("OrgWechatCustomActivity is : {} ", (Object)customActivity);
        if (customActivity == null) {
            return null;
        }
        Integer replaceOrgId = customActivity.getReplaceOrgId();
        String qrCodeUrl = customActivity.getQrCodeUrl();
        if (replaceOrgId != null && replaceOrgId != -1) {
            AuthorizerInfo authi = this.wechatFreeVersionService.getFAAuthorizerInfo();
            log.info("free authorizerInfo is :{} and replaceOrgId is: {} ", (Object)authi, (Object)replaceOrgId);
            boolean isFreeAccount = this.wechatFreeVersionService.isFreeAccount(customActivity.getOriginOrgId());
            log.info("boolean isFreeAccount for orgId : {} , {}", (Object)customActivity.getOriginOrgId(), (Object)isFreeAccount);
            AuthorizerInfo authorizerInfo = null;
            if (isFreeAccount) {
                log.info("is free account");
                authorizerInfo = this.wechatFreeVersionService.getFAAuthorizerInfo();
            } else {
                authorizerInfo = this.authorizerInfoService.getByOrgId(customActivity.getOriginOrgId());
            }
            if (authorizerInfo == null) {
                return null;
            }
            Integer qrcodeStorageId = authorizerInfo.getQrcodeStorageId();
            qrCodeUrl = this.retrievalImgUrl(qrcodeStorageId);
        }
        String relativePath = TemplateConstant.getTemplateUrl((Integer)activityType);
        CustomActivityDto dto = new CustomActivityDto();
        dto.setActivityId(activityId);
        dto.setActivityType(activityType);
        dto.setQrCodeUrl(qrCodeUrl);
        dto.setKeyWord(customActivity.getKeyWrod());
        dto.setReplaceOrgId(customActivity.getReplaceOrgId());
        dto.setWebAuthUrl(WechatWebAuthLinkBuilder.customActivity(WebAuthScope.BASE, customActivity.getAuthorizerAppId(), activityId, activityType, relativePath));
        return dto;
    }

    private String retrievalImgUrl(Integer qrcodeStorageId) {
        OrgStorage orgStorage = this.orgStorageDao.getById(qrcodeStorageId.intValue());
        if (orgStorage == null) {
            log.info("can not retrieval authorizerInfo's qrCodeUrl {} ", (Object)qrcodeStorageId);
            return null;
        }
        return StorageUtil.constructUrl(orgStorage.getFid(), orgStorage.getSn(), orgStorage.getMimeType());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteCustomActivity(int activityId, int activityType) {
        this.customActivityDao.deleteBy(activityId, activityType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CustomActivityDto createCustomActivityForReplace(Integer replaceOrgId, int originOrgId, int activityId, int templateId, String title, String description, String picUrl) throws Exception {
        boolean needReplace = false;
        Integer orgId = originOrgId;
        boolean needFilterSubscribe = false;
        AuthorizerInfo authorizerInfo = this.authorizerInfoService.getByOrgId(originOrgId);
        boolean isFreeAccount = false;
        if (authorizerInfo == null) {
            isFreeAccount = this.wechatFreeVersionService.isFreeAccount(originOrgId);
            if (!isFreeAccount) return null;
            orgId = replaceOrgId;
            needReplace = true;
            log.info(" organization : {} is a free account  ,and will replace with : {} ", (Object)originOrgId, (Object)replaceOrgId);
        } else {
            if (!authorizerInfo.isServiceApp() || !authorizerInfo.isPassedVerify()) {
                orgId = replaceOrgId;
                needReplace = true;
                log.info(" not have enought permission ,and will replace with : {} ", (Object)replaceOrgId);
            }
            boolean passedVerify = authorizerInfo.isPassedVerify();
            boolean isSubscribeAccoutn = false;
            Integer serviceType = authorizerInfo.getServiceType();
            if (serviceType != null && (serviceType == 0 || serviceType == 1)) {
                isSubscribeAccoutn = true;
            }
            boolean bl = needFilterSubscribe = !passedVerify || !isSubscribeAccoutn;
        }
        if (needReplace && replaceOrgId == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, String.format("orgId : {} need replace with system wechat account , but find nothing  ", originOrgId));
        }
        CustomActivityDto createCustomActivity = this.createCustomActivity(orgId, activityId, templateId, title, description, picUrl);
        OrgWechatCustomActivity customActivity = this.customActivityDao.get(activityId, templateId);
        if (needReplace) {
            String keywordFormat = "[{'keyword':'%s','isExactMatch':1}]";
            String keyWord = this.createKeyWord(activityId, templateId);
            keyWord = String.format(keywordFormat, keyWord);
            log.info("keyword is : {} ", (Object)keyWord);
            MediaType mediaType = MediaType.ZIDINGYILIANJIE;
            customActivity.setKeyWrod(keyWord);
            String url = createCustomActivity.getWebAuthUrl();
            url = ShortUrlUtil.getShortUrl((String)url);
            Integer originOrgIdTmp = originOrgId;
            if (isFreeAccount) {
                originOrgIdTmp = replaceOrgId;
            }
            OrgWechatReplyForKeyword saveOrUpdateKeywordReply = this.autoReplyService.saveOrUpdateKeywordReply(originOrgIdTmp, null, keyWord, mediaType.getValue(), null, url, null, "");
            log.info("create autoReply obj is : {} ", (Object)saveOrUpdateKeywordReply);
            customActivity.setReplaceOrgId(replaceOrgId);
            customActivity.setOriginOrgId(Integer.valueOf(originOrgId));
            this.saveReplaceInfo(originOrgId, replaceOrgId, needFilterSubscribe);
        }
        customActivity.setAuthorizerAppId(createCustomActivity.getAuthorizerAppId());
        customActivity.setQrCodeUrl(createCustomActivity.getQrCodeUrl());
        log.info("customActivity obj is : {} ", (Object)customActivity);
        try {
            this.customActivityDao.saveOrUpdate((Object)customActivity, new String[0]);
            log.info("wechat - CustomActivityServiceImpl - createCustomActivity - obj:{}", (Object)customActivity);
            return createCustomActivity;
        }
        catch (Exception e) {
            log.error("wechat - CustomActivityServiceImpl - createCustomActivity - exception - obj:{}", (Object)customActivity);
            throw e;
        }
    }

    private void saveReplaceInfo(int originOrgId, int replaceOrgId, boolean needFilterSubscribe) {
        try {
            ActivityWechatReplace replace = new ActivityWechatReplace();
            replace.setOriginOrgId(Integer.valueOf(originOrgId));
            replace.setReplaceOrgId(Integer.valueOf(replaceOrgId));
            replace.setNeedFilterSubscribe(needFilterSubscribe ? 0 : 1);
            this.activityWechatReplaceDao.save((Object)replace, new String[0]);
        }
        catch (DuplicateKeyException e) {
            log.info("has alerdy insert {} ", (Object)(originOrgId + "_" + replaceOrgId));
        }
    }

    private String createKeyWord(int activityId, int activityType) {
        String desc = this.createDescOfActivity(activityType);
        return desc + activityId;
    }

    private String createDescOfActivity(Integer templateId) {
        Template selectTemplateById = this.templateDao.selectTemplateById(templateId);
        Integer activityType = -1;
        if (selectTemplateById != null) {
            activityType = selectTemplateById.getTypeId();
        }
        switch (activityType) {
            case 3: {
                return "\u5fae\u6d3b\u52a8";
            }
            case 99: {
                return "\u62bd\u5956";
            }
            case 201: {
                return "\u6295\u7968";
            }
            case 301: {
                return "\u8f6c\u4ecb\u7ecd";
            }
        }
        return "\u8425\u9500";
    }
}

