/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatReplyForKeywordDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatReplyForSubscribeDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForKeyword;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForSubscribe;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.PermissionException;
import com.baijia.tianxiao.sal.wechat.api.AutoReplyService;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.dto.autoreply.KeywordReplyDto;
import com.baijia.tianxiao.sal.wechat.dto.autoreply.SubscribeReplyDto;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.OrgWechatDto;
import com.baijia.tianxiao.sal.wechat.validator.AutoReplyValidator;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONArray;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AutoReplyServiceImpl
implements AutoReplyService {
    @Autowired
    private OrgWechatReplyForKeywordDao orgWechatReplyForKeywordDao;
    @Autowired
    private OrgWechatReplyForSubscribeDao orgWechatReplyForSubscribeDao;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private OrgAccountDao orgAccountDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OrgWechatReplyForKeyword saveOrUpdateKeywordReply(Integer orgId, Integer id, String keywords, int mediaType, String mediaId, String url, String content, String note) {
        JSONArray keywordsArray;
        MediaType type;
        if (mediaId == null) {
            mediaId = "";
        }
        if (url == null) {
            url = "";
        }
        if (content == null) {
            content = "";
        }
        if (note == null) {
            note = "";
        }
        if (StringUtils.isBlank((CharSequence)keywords)) {
            keywords = "[]";
        }
        if ((type = MediaType.getByVaule(mediaType)) == MediaType.CONTENT) {
            AutoReplyValidator._4Content(content);
        }
        if ((keywordsArray = JSONArray.fromObject((Object)keywords)) != null && !keywordsArray.isEmpty()) {
            for (int i = 0; i < keywordsArray.size(); ++i) {
                AutoReplyValidator._4Keyword(keywordsArray.getJSONObject(i).getString("keyword"));
            }
        }
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(orgId);
        OrgWechatReplyForKeyword reply = null;
        if (id != null && (reply = (OrgWechatReplyForKeyword)this.orgWechatReplyForKeywordDao.getById((Serializable)id, new String[0])) == null) {
            throw new PermissionException();
        }
        if (authorizerInfo == null) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
        }
        if (reply != null && !reply.getAuthorizerAppId().equals(authorizerInfo.getAuthorizerAppId())) {
            throw new PermissionException();
        }
        Date now = new Date();
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(authorizerInfo.getOrgId().intValue(), new String[0]);
        OrgWechatDto orgWechatDto = new OrgWechatDto(orgAccount.getId(), orgAccount.getNumber(), authorizerInfo.getAuthorizerAppId());
        if (type == MediaType.ZIDINGYILIANJIE) {
            url = MediaType.fillUrlWithHttp(url);
        }
        if (reply == null) {
            reply = new OrgWechatReplyForKeyword();
            reply.setAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
            reply.setContent(content);
            reply.setCreateTime(now);
            reply.setId(id);
            reply.setKeywords(keywords);
            reply.setMediaId(mediaId);
            reply.setMediaType(Integer.valueOf(mediaType));
            reply.setUpdateTime(now);
            reply.setUrl(StringUtils.isNotBlank((CharSequence)url) ? url : type.getUrl(orgWechatDto));
            reply.setNote(note);
            this.orgWechatReplyForKeywordDao.save((Object)reply, Boolean.valueOf(true), new String[0]);
        } else {
            reply.setContent(content);
            reply.setKeywords(keywords);
            reply.setMediaId(mediaId);
            reply.setMediaType(Integer.valueOf(mediaType));
            reply.setUpdateTime(now);
            reply.setUrl(StringUtils.isNotBlank((CharSequence)url) ? url : type.getUrl(orgWechatDto));
            reply.setNote(note);
            this.orgWechatReplyForKeywordDao.update((Object)reply, Boolean.valueOf(true), new String[0]);
        }
        return reply;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delKeywordReply(Integer orgId, Integer id) {
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(orgId);
        OrgWechatReplyForKeyword reply = null;
        if (id != null && (reply = (OrgWechatReplyForKeyword)this.orgWechatReplyForKeywordDao.getById((Serializable)id, new String[0])) == null) {
            throw new PermissionException();
        }
        if (authorizerInfo == null) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
        }
        if (reply != null && !reply.getAuthorizerAppId().equals(authorizerInfo.getAuthorizerAppId())) {
            throw new PermissionException();
        }
        this.orgWechatReplyForKeywordDao.delById((Serializable)id);
    }

    @Override
    @Transactional(readOnly=true)
    public List<KeywordReplyDto> listKeywordReply(Integer orgId, PageDto pageDto) {
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(orgId);
        String authorizerAppId = authorizerInfo.getAuthorizerAppId();
        Integer count = this.orgWechatReplyForKeywordDao.count(authorizerAppId);
        List list = null;
        list = count > 0 ? this.orgWechatReplyForKeywordDao.search(authorizerAppId, pageDto) : new ArrayList();
        pageDto.setCurPageCount(Integer.valueOf(list.size()));
        pageDto.setCount(count);
        ArrayList<KeywordReplyDto> dtoList = new ArrayList<KeywordReplyDto>();
        if (list != null && !list.isEmpty()) {
            for (OrgWechatReplyForKeyword replyForKeyword : list) {
                KeywordReplyDto dto = new KeywordReplyDto();
                dto.setContent(replyForKeyword.getContent());
                dto.setId(replyForKeyword.getId());
                dto.setKeywords(JSONArray.fromObject((Object)replyForKeyword.getKeywords()));
                dto.setMediaId(replyForKeyword.getMediaId());
                dto.setMediaType(replyForKeyword.getMediaType());
                dto.setUrl(replyForKeyword.getUrl());
                dto.setNote(replyForKeyword.getNote());
                MediaType type = MediaType.getByVaule(dto.getMediaType());
                if (StringUtils.isBlank((CharSequence)dto.getNote())) {
                    String fmt = "[%s]%s";
                    String body = "";
                    if (type == MediaType.CONTENT && dto.getContent() != null) {
                        body = dto.getContent();
                    } else if (type == MediaType.ZIDINGYILIANJIE && dto.getUrl() != null) {
                        body = dto.getUrl();
                    }
                    fmt = String.format(fmt, type.getLabel(), body);
                    dto.setNote(fmt);
                }
                if (type == MediaType.IMAGE && dto.getUrl() != null) {
                    dto.setContent(dto.getNote());
                } else if (type == MediaType.VOICE && dto.getUrl() != null) {
                    dto.setContent(dto.getNote());
                }
                dtoList.add(dto);
            }
        }
        return dtoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdateSubscribeReply(Integer orgId, int mediaType, String mediaId, String url, String content, String note) {
        AuthorizerInfo authorizerInfo;
        MediaType type;
        if (mediaId == null) {
            mediaId = "";
        }
        if (url == null) {
            url = "";
        }
        if (content == null) {
            content = "";
        }
        if (note == null) {
            note = "";
        }
        if ((type = MediaType.getByVaule(mediaType)) == MediaType.CONTENT) {
            AutoReplyValidator._4Content(content);
        }
        if ((authorizerInfo = this.authorizerInfoDao.getByOrgId(orgId)) == null) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
        }
        OrgWechatReplyForSubscribe reply = this.orgWechatReplyForSubscribeDao.getByAppId(authorizerInfo.getAuthorizerAppId());
        if (reply != null && !reply.getAuthorizerAppId().equals(authorizerInfo.getAuthorizerAppId())) {
            throw new PermissionException();
        }
        Date now = new Date();
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(authorizerInfo.getOrgId().intValue(), new String[0]);
        OrgWechatDto orgWechatDto = new OrgWechatDto(orgAccount.getId(), orgAccount.getNumber(), authorizerInfo.getAuthorizerAppId());
        if (type == MediaType.ZIDINGYILIANJIE) {
            url = MediaType.fillUrlWithHttp(url);
        }
        if (reply == null) {
            reply = new OrgWechatReplyForSubscribe();
            reply.setAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
            reply.setContent(content);
            reply.setCreateTime(now);
            reply.setId(null);
            reply.setMediaId(mediaId);
            reply.setMediaType(Integer.valueOf(mediaType));
            reply.setUpdateTime(now);
            reply.setUrl(StringUtils.isNotBlank((CharSequence)url) ? url : type.getUrl(orgWechatDto));
            reply.setNote(note);
            this.orgWechatReplyForSubscribeDao.save((Object)reply, Boolean.valueOf(true), new String[0]);
        } else {
            reply.setContent(content);
            reply.setMediaId(mediaId);
            reply.setMediaType(Integer.valueOf(mediaType));
            reply.setUpdateTime(now);
            reply.setUrl(StringUtils.isNotBlank((CharSequence)url) ? url : type.getUrl(orgWechatDto));
            reply.setNote(note);
            this.orgWechatReplyForSubscribeDao.update((Object)reply, Boolean.valueOf(true), new String[0]);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public SubscribeReplyDto getSubscribeReply(Integer orgId) {
        SubscribeReplyDto dto = null;
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(orgId);
        if (authorizerInfo == null) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
        }
        OrgWechatReplyForSubscribe reply = this.orgWechatReplyForSubscribeDao.getByAppId(authorizerInfo.getAuthorizerAppId());
        if (reply != null) {
            dto = new SubscribeReplyDto();
            dto.setContent(reply.getContent());
            dto.setId(reply.getId());
            dto.setMediaId(reply.getMediaId());
            dto.setMediaType(reply.getMediaType());
            dto.setUrl(reply.getUrl());
            dto.setNote(reply.getNote());
        }
        return dto;
    }
}

