/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.wechat.constant.WechatOpenIdEntityType;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatOpenIdRecordDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatOpenIdRecord;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.api.WechatFreeVersionService;
import com.baijia.tianxiao.sal.wechat.api.WechatOpenIdRecordService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatOpenIdRecordServiceImpl
implements WechatOpenIdRecordService {
    private static final Logger log = LoggerFactory.getLogger(WechatOpenIdRecordServiceImpl.class);
    @Autowired
    private OrgWechatOpenIdRecordDao wechatOpenIdRecordDao;
    @Autowired
    private WechatFreeVersionService freeVersionService;
    @Autowired
    private AuthorizerInfoService authorizerInfoService;
    @Autowired
    private FansDao fansDao;

    @Override
    public List<Long> listOrgIdBy(String wechatAppId, String openId, WechatOpenIdEntityType entityType) {
        ArrayList<Long> orgIdlist = new ArrayList<Long>();
        if (this.freeVersionService.isFreeAccount(wechatAppId)) {
            List list = this.wechatOpenIdRecordDao.listBy(wechatAppId, openId, entityType);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (OrgWechatOpenIdRecord record : list) {
                    if (!this.freeVersionService.isFreeAccountOrUnBindWechatApp(record.getOrgId().intValue())) continue;
                    orgIdlist.add(record.getOrgId());
                }
            }
        } else {
            Fans fans;
            AuthorizerInfo authorizerInfo = this.authorizerInfoService.getByAuthorizerAppId(wechatAppId);
            if (authorizerInfo != null && (fans = this.fansDao.getByOpenId(openId)) != null && fans.getAuthorizerAppId().equals(authorizerInfo.getAuthorizerAppId())) {
                orgIdlist.add(authorizerInfo.getOrgId().longValue());
            }
        }
        return orgIdlist;
    }

    @Override
    public Long getStudentIdBy(String wechatAppId, Long orgId, String openId) {
        List records = this.wechatOpenIdRecordDao.listBy(wechatAppId, orgId, openId, WechatOpenIdEntityType.STUDENT);
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            OrgWechatOpenIdRecord record = (OrgWechatOpenIdRecord)records.get(0);
            if (this.freeVersionService.isFreeAccount(wechatAppId)) {
                if (this.freeVersionService.isFreeAccountOrUnBindWechatApp(record.getOrgId().intValue())) {
                    return record.getEntityId();
                }
                return null;
            }
            return record.getEntityId();
        }
        return null;
    }

    @Override
    public void saveOrUpdateByUniqueKey(OrgWechatOpenIdRecord record) {
        WechatOpenIdEntityType type = WechatOpenIdEntityType.getByValue((int)record.getEntityType());
        OrgWechatOpenIdRecord dbRecord = this.wechatOpenIdRecordDao.getBy(record.getAuthorizerAppId(), record.getOrgId(), record.getEntityId(), type);
        if (dbRecord != null) {
            record.setId(dbRecord.getId());
            record.setCreateTime(dbRecord.getCreateTime());
        }
        try {
            this.wechatOpenIdRecordDao.saveOrUpdate((Object)record, new String[0]);
        }
        catch (Exception e) {
            try {
                dbRecord = this.wechatOpenIdRecordDao.getBy(record.getAuthorizerAppId(), record.getOrgId(), record.getEntityId(), type);
                if (dbRecord != null) {
                    record.setId(dbRecord.getId());
                    record.setCreateTime(dbRecord.getCreateTime());
                }
            }
            catch (Exception e1) {
                log.warn("saveOrUpdateByUniqueKey - error - record:{}, e:{}", (Object)record, (Object)e1);
            }
        }
    }

    @Override
    public List<OrgWechatOpenIdRecord> listBy(Long orgId, String openId, WechatOpenIdEntityType entityType) {
        return this.wechatOpenIdRecordDao.listBy(orgId, openId, entityType);
    }

    @Override
    public void deleteByUniqueKey(OrgWechatOpenIdRecord record) {
        WechatOpenIdEntityType type = WechatOpenIdEntityType.getByValue((int)record.getEntityType());
        OrgWechatOpenIdRecord dbRecord = this.wechatOpenIdRecordDao.getBy(record.getAuthorizerAppId(), record.getOrgId(), record.getEntityId(), type);
        if (dbRecord != null) {
            this.wechatOpenIdRecordDao.delById((Serializable)dbRecord.getId());
        }
    }
}

