/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.dto.org;

import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.wechat.constant.WechatOpenIdEntityType;
import com.baijia.tianxiao.dto.smstoken.WechatSmsTokenDto;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrgCenterInfo {
    private static final Logger log = LoggerFactory.getLogger(OrgCenterInfo.class);
    private WechatOpenIdEntityType type;
    private String orgName;
    private String orgShortName;
    private Integer orgId;
    private Integer orgNumber;
    private String appId;
    private String url;

    public String getUrl() {
        if (this.type != null) {
            switch (this.type) {
                case STUDENT: {
                    this.url = WechatWebAuthLinkBuilder.studentCenter(WebAuthScope.BASE, this.appId, this.orgId.longValue());
                    break;
                }
                case TEACHER: {
                    this.url = WechatWebAuthLinkBuilder.teacherCenter(WebAuthScope.BASE, this.appId, this.orgId.longValue());
                    break;
                }
            }
        }
        return this.url;
    }

    public static List<OrgCenterInfo> convertBy(String appId, List<OrgInfo> orgInfos, WechatOpenIdEntityType type) {
        ArrayList<OrgCenterInfo> list = new ArrayList<OrgCenterInfo>();
        OrgCenterInfo ocInfo = null;
        if (CollectionUtils.isNotEmpty(orgInfos)) {
            for (OrgInfo info : orgInfos) {
                ocInfo = new OrgCenterInfo();
                ocInfo.setAppId(appId);
                ocInfo.setOrgId(info.getOrgId());
                ocInfo.setOrgName(info.getName());
                ocInfo.setOrgShortName(info.getShortName());
                ocInfo.setType(type);
                list.add(ocInfo);
            }
        }
        return list;
    }

    public static String getCenterSelectUrl(Long orgId, String wechatAppId) {
        String fmt = "%swechat/webauth/centerSelect.do?sms_token=%s";
        WechatSmsTokenDto dto = new WechatSmsTokenDto(orgId, wechatAppId);
        try {
            fmt = String.format(fmt, WechatProperties.getWebCRMUrlPrefix(), dto.toTokenStr());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return fmt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public WechatOpenIdEntityType getType() {
        return this.type;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public String getOrgShortName() {
        return this.orgShortName;
    }

    public Integer getOrgId() {
        return this.orgId;
    }

    public Integer getOrgNumber() {
        return this.orgNumber;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setType(WechatOpenIdEntityType type) {
        this.type = type;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public void setOrgShortName(String orgShortName) {
        this.orgShortName = orgShortName;
    }

    public void setOrgId(Integer orgId) {
        this.orgId = orgId;
    }

    public void setOrgNumber(Integer orgNumber) {
        this.orgNumber = orgNumber;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrgCenterInfo)) {
            return false;
        }
        OrgCenterInfo other = (OrgCenterInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WechatOpenIdEntityType this$type = this.getType();
        WechatOpenIdEntityType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$orgName = this.getOrgName();
        String other$orgName = other.getOrgName();
        if (this$orgName == null ? other$orgName != null : !this$orgName.equals(other$orgName)) {
            return false;
        }
        String this$orgShortName = this.getOrgShortName();
        String other$orgShortName = other.getOrgShortName();
        if (this$orgShortName == null ? other$orgShortName != null : !this$orgShortName.equals(other$orgShortName)) {
            return false;
        }
        Integer this$orgId = this.getOrgId();
        Integer other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
            return false;
        }
        Integer this$orgNumber = this.getOrgNumber();
        Integer other$orgNumber = other.getOrgNumber();
        if (this$orgNumber == null ? other$orgNumber != null : !((Object)this$orgNumber).equals(other$orgNumber)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrgCenterInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WechatOpenIdEntityType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $orgName = this.getOrgName();
        result = result * 59 + ($orgName == null ? 43 : $orgName.hashCode());
        String $orgShortName = this.getOrgShortName();
        result = result * 59 + ($orgShortName == null ? 43 : $orgShortName.hashCode());
        Integer $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
        Integer $orgNumber = this.getOrgNumber();
        result = result * 59 + ($orgNumber == null ? 43 : ((Object)$orgNumber).hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }
}

