/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.validator;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.exception.ParameterException;

/**   
 * @title       : AutoReplyValidator 
 * @description : 自定义回复验证
 * @author      : zhenyujian
 * @date        : 2016年1月14日 下午8:23:46 
 */
public class AutoReplyValidator {
	
	
	
	/**
	 * @Description  : 关键字 最多30个字符
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月14日 下午8:25:39 
	 *
	 * @Return       : void
	 */
	public static void _4Keyword(String keyword) throws ParameterException{
		if(keyword==null){
			throw new ParameterException("关键词不能为空");
		}
		
		if( !(keyword.length()>=0 && keyword.length()<=30) ){
			throw new ParameterException("单个关键词最多允许输入30个字符");
    	}
	}
	
	
	
	/**
	 * @Description  : 回复内容 最多300个字符 
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月14日 下午8:27:45 
	 *
	 * @Return       : void
	 */
	public static void _4Content(String content) throws ParameterException{
		if( !(StringUtils.isNotBlank(content) && content.length()>=0 && content.length()<=300) ){
			throw new ParameterException("回复内容最多允许输入300个字符");
    	}
	}
	
}

