/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.util;

import java.io.File;
import java.util.Random;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;


public class LocalFileHelper {
	

    private static final Logger logger = LoggerFactory.getLogger(LocalFileHelper.class);
	
    
    public static File saveToLocal(byte[] data, MIMEType fileType) {
        return saveToLocal(data, fileType.getExtension());
    }
    
    public static File saveToLocal(byte[] data, String extension) {
        try {
            String tmpDir = getTmpDir();
            String tmpFile = tmpDir + File.separator + random() + "." + extension;

            boolean ret = FileUtil.write(tmpFile, data);
            logger.debug("saveToLocal - tmpfile:{}, data.len:{}, result:{}", tmpFile, data.length, ret);
            return new File(tmpFile);
        } catch (Exception e) {
            logger.error("saveToLocal error", e);
            throw new RuntimeException("save to local exception - ", e);
        }
    }
    
    public static void deleteFile(File file) {
        file.delete();
        logger.debug("deleteFile - file:{}", file);
    }
    
    
    
    private static String getTmpDir() {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (StringUtils.isBlank(tmpDir)) {
            tmpDir = WechatProperties.getUpLoadDefaultTmpdir();
        }
        logger.trace("getTmpDir - tmpdir:{}", tmpDir);
        return tmpDir;
    }

    private static int random() {
        Random r = new Random();
        return Math.abs(r.nextInt());
    }
    
    
    public static String getTmpFileName(String extension){
    	String tmpDir = getTmpDir();
        String tmpFile = tmpDir + File.separator + random() + "." + extension;
        return tmpFile;
    }
    
}

