/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.task;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**   
 * @title       : TaskHelper 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2015年12月9日 上午12:50:42 
 */
public class TaskHelper {
	

    private Logger logger = LoggerFactory.getLogger(TaskHelper.class);
    private static final int MIN_THREAD_POOL_SIZE = 5;
    private static final int MAX_THREAD_POOL_SIZE = 20;
    private static final int MAX_TASK_QUEUE_SIZE  = 100;

	//线程池
    private static ExecutorService threadPool;
    //任务队列
    private static ArrayBlockingQueue<Runnable> taskQueue;
    
    private static Object lock = new Object(); 
    
    private Thread taskManager;
    
    private static TaskHelper taskHelper = null;  
    
    private TaskHelper(){
    }
    
    
    
    public static TaskHelper getInstance() throws InterruptedException {  
         if(null == taskHelper){
             synchronized (lock) {
                 if(null == taskHelper){
                	 taskHelper = new TaskHelper();
                	 taskQueue  = new ArrayBlockingQueue<Runnable>(MAX_TASK_QUEUE_SIZE);
                	 int alSize = Runtime.getRuntime().availableProcessors();
                	 alSize = alSize>MIN_THREAD_POOL_SIZE ? alSize:MIN_THREAD_POOL_SIZE;
                	 alSize = alSize>MAX_THREAD_POOL_SIZE ? MAX_THREAD_POOL_SIZE:alSize;
                	 
                	 threadPool = Executors.newFixedThreadPool( alSize );
                	 
                	 taskHelper.taskManager = new Thread(new TaskManager());
                	 taskHelper.taskManager.start();
                	 while(!taskHelper.taskManager.isAlive()){
                         Thread.sleep(100);
                     }
                 }
             }
         }
        return taskHelper;  
    }  
    
    
    
    static class TaskManager implements Runnable{
        
        private Logger logger = LoggerFactory.getLogger(TaskManager.class);
        
        @Override
        public void run() {
            while(true){
                try {
                	Runnable task = taskQueue.take();
                    threadPool.execute(task);
                    Thread.sleep(10);
                } catch (InterruptedException e) {
                    logger.error("TaskHelper - TaskManager e:{}",e);
                }
            }
        }
    }
    
    
    
    public void addTask(Runnable task) throws InterruptedException{
    	logger.info("addTask - task:{}",task);
        if(task!=null && !taskQueue.offer(task) ){
        	logger.error("TaskHelper - addTask - sending Queue has reached max element ", MAX_TASK_QUEUE_SIZE);
        }
    }
    
    
}

