/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.ComponentAccessTokenDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.ComponentAccessToken;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.sal.wechat.api.WebAuthService;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.dto.webauth.WebAuthDto;
import com.baijia.tianxiao.sal.wechat.dto.webauth.WebAuthorizationDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.OpenPlatformInfoDto;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.webauth.WechatWebAuthHelper;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;


@Service
public class WebAuthServiceImpl implements WebAuthService{

	@Autowired
    private ComponentAccessTokenDao componentAccessTokenDao;
	@Autowired
    private AuthorizerInfoDao authorizerInfoDao;
	
	
	/**
	 * @Description  : 通过 '网页授权' 的code获取 微信用户的基本信息
	 * @Author       : zhenyujian
	 * @CreationDate : 2015年7月6日 下午2:06:53 
	 *
	 * @Return       : WechatUser
	 */
	@Transactional(readOnly=true)
	@Override
	public Fans 	getWechatUserByWebAuthCode(WebAuthDto webAuthDto){
		Fans fans = null;
		OpenPlatformInfoDto platformInfo = WechatProperties.getOpenPlatformInfo();
		ComponentAccessToken compAccessToken = componentAccessTokenDao.getByAppId(platformInfo.getAppId());
		
		//调用微信接口 获取授权token		
		WebAuthorizationDto webAuthorizationDto = WechatWebAuthHelper.getWebAuthorization(webAuthDto.getAppid(), 
																						  webAuthDto.getCode(),
				   																		  platformInfo.getAppId(),
				   																		  compAccessToken.getComponentAccessToken());
		if( webAuthorizationDto!=null ){
			//调用微信接口 获取用户信息
			fans = WechatWebAuthHelper.getUserInfoByWebAuth(webAuthorizationDto.getAccessToken(), webAuthorizationDto.getOpenid());
		}
		
		return fans;
	}
	
	
	
	/**
	 * @Description  : 通过 '网页授权' 的code获取 用户的授权信息
	 * @Author       : zhenyujian
	 * @CreationDate : 2015年7月6日 下午2:07:06 
	 *
	 * @Return       : WebAuthorizationDto
	 */
	@Transactional(readOnly = true)
	@Override
	public WebAuthorizationDto getWebAuthorizationDtoByWebAuthCode(WebAuthDto webAuthDto){
		OpenPlatformInfoDto platformInfo = WechatProperties.getOpenPlatformInfo();
		ComponentAccessToken compAccessToken = componentAccessTokenDao.getByAppId(platformInfo.getAppId());
		
		return WechatWebAuthHelper.getWebAuthorization(webAuthDto.getAppid(),
													   webAuthDto.getCode(),
				  									   platformInfo.getAppId(),
				  									   compAccessToken.getComponentAccessToken());
	}

	

	@Transactional(readOnly = true)
	@Override
	public String getFansinfoLink(Integer orgId, String landingPage) {
		AuthorizerInfo info = authorizerInfoDao.getByOrgId(orgId);
		return WechatWebAuthLinkBuilder.fansinfo(WebAuthScope.BASE, info.getAuthorizerAppId(), landingPage);
	}


	
	@Transactional(readOnly = true)
	@Override
	public String getFansinfoLink4UserInfoScope(Integer orgId, String landingPage) {
		AuthorizerInfo info = authorizerInfoDao.getByOrgId(orgId);
		return WechatWebAuthLinkBuilder.fansinfo(WebAuthScope.USERINFO, info.getAuthorizerAppId(), landingPage);
	}

}

