/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.webauthlink;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import lombok.extern.slf4j.Slf4j;

import com.baijia.tianxiao.dto.smstoken.WechatSmsTokenDto;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;

/**
 * @author : zhenyujian
 * @title : WechatWebAuthLinkHelper
 * @description : 获取 微信网页授权链接
 * @date : 2016年1月6日 下午5:26:17
 */
@Slf4j
public class WechatWebAuthLinkBuilder {

    /**
     * @Description : 获取网页授权者信息
     * @Author : zhenyujian
     * @Date : 2016年1月26日 下午7:57:34
     * @Return : String
     */
    public static String fansinfo(WebAuthScope scope, String appId, String landingPage) {
        StringBuilder redirectUrl = new StringBuilder();
        try {
            redirectUrl.append(WechatProperties.getWebAuthUrlPrefix()).append("fansinfo.do?").append("&landingPage=")
                .append(URLEncoder.encode(landingPage, "utf8"));
        } catch (UnsupportedEncodingException e) {
            log.warn("error is:{} ", e);
            e.printStackTrace();
        }

        return WechatWebAuthLinkHelper.getWebAuthLink(appId, redirectUrl.toString(), scope);
    }

    /**
     * @Description : 个人中心
     * @Author : zhenyujian
     * @Date : 2016年1月6日 下午5:41:20
     * @Return : String
     */
    public static String studentCenter(WebAuthScope scope, String appId) {
        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append(WechatProperties.getWebAuthUrlPrefix()).append("personalCenter.do?");

        return WechatWebAuthLinkHelper.getWebAuthLink(appId, redirectUrl.toString(), scope);
    }

    public static String studentCenter(WebAuthScope scope, String appId, Long orgId) {
        WechatSmsTokenDto dto = new WechatSmsTokenDto(orgId.longValue(), appId);
        String sms_token = null;
        try {
            sms_token = dto.toTokenStr();
        } catch (Exception e) {
            log.error("toTokenStr error sms_token:{}", sms_token);
        }
        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append(WechatProperties.getWebAuthUrlPrefix()).append("personalCenter.do?").append("sms_token=")
            .append(sms_token);

        return WechatWebAuthLinkHelper.getWebAuthLink(appId, redirectUrl.toString(), scope);
    }

    /**
     * @Description : 老师
     * @Author : zhenyujian
     * @Date : 2016年3月28日 下午7:37:25
     * @Return : String
     */
    public static String teacherCenter(WebAuthScope scope, String appId, Long orgId) {
        WechatSmsTokenDto dto = new WechatSmsTokenDto(orgId.longValue(), appId);
        String sms_token = null;
        try {
            sms_token = dto.toTokenStr();
        } catch (Exception e) {
            log.error("toTokenStr error sms_token:{}", sms_token);
        }

        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append(WechatProperties.getWebAuthUrlPrefix()).append("teacherCenter.do?").append("sms_token=")
            .append(sms_token);

        return WechatWebAuthLinkHelper.getWebAuthLink(appId, redirectUrl.toString(), scope);
    }

    public static String teacherCenter(WebAuthScope scope, String appId) {
        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append(WechatProperties.getWebAuthUrlPrefix()).append("teacherCenter.do?");

        return WechatWebAuthLinkHelper.getWebAuthLink(appId, redirectUrl.toString(), scope);
    }

    /**
     * @Description : 我的课表
     * @Author : zhenyujian
     * @Date : 2016年1月8日 下午8:16:11
     * @Return : String
     */
    public static String schedule(WebAuthScope scope, String appId) {
        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append(WechatProperties.getWebAuthUrlPrefix()).append("schedule.do?");

        return WechatWebAuthLinkHelper.getWebAuthLink(appId, redirectUrl.toString(), scope);
    }

    /**
     * @Description : 我的签到记录
     * @Author : zhenyujian
     * @Date : 2016年1月8日 下午8:17:09
     * @Return : String
     */
    public static String mySigninRecord(WebAuthScope scope, String appId) {
        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append(WechatProperties.getWebAuthUrlPrefix()).append("signinRecord.do?");

        return WechatWebAuthLinkHelper.getWebAuthLink(appId, redirectUrl.toString(), scope);
    }

    /**
     * @Description : 我的评价
     * @Author : zhenyujian
     * @Date : 2016年1月8日 下午8:18:05
     * @Return : String
     */
    public static String rating(WebAuthScope scope, String appId) {
        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append(WechatProperties.getWebAuthUrlPrefix()).append("rating.do?");

        return WechatWebAuthLinkHelper.getWebAuthLink(appId, redirectUrl.toString(), scope);
    }

    /**
     * @Description : 自定义活动
     * @Author : zhenyujian
     * @Date : 2016年1月29日 上午10:10:25
     * @Return : String
     */
    public static String customActivity(WebAuthScope scope, String appId, int activityId, int activityType,
        String relativePath) {

        StringBuilder landingPage = new StringBuilder();
        landingPage.append(WechatProperties.getWebMarketingUrlPrefix());
        landingPage.append(relativePath);

        landingPage.append("&activityId=").append(activityId);
        landingPage.append("&activityType=").append(activityType);
        return fansinfo(scope, appId, landingPage.toString());
    }

    /**
     * @Description : h5聊天
     * @Author : zhenyujian
     * @Date : 2016年8月31日 上午12:42:20
     * @Return : String
     */
    public static String imSite(WebAuthScope scope, String appId, String sms_token) {
        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append(WechatProperties.getWebAuthUrlPrefix()).append("imsite.do?").append("&sms_token=")
            .append(sms_token);

        return WechatWebAuthLinkHelper.getWebAuthLink(appId, redirectUrl.toString(), scope);
    }

    /**
     * 如果是统一公众号地址，需要转下webauth授权
     *
     * @param scope
     * @param appId
     * @param redirectUrl
     * @return
     */
    public static String wxIndex(WebAuthScope scope, String appId, String redirectUrl) {

        return WechatWebAuthLinkHelper.getWebAuthLink(appId, redirectUrl.toString(), scope);
    }
}
