/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.media;

import java.io.File;

import net.sf.json.JSONObject;

import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.dto.media.MediaCountDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.PermanentMediaApiDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.TempMediaApiDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;

/**   
 * @Title       : WechatMenuApiCaller 
 * @Description : 微信 素材管理相关接口
 * @Author      : zhenyujian
 * @Date        : 2015年12月3日 下午4:09:56 
 */
public class WechatMediaApiHelper {
	
	/**
	 * @Description  : 新增临时素材
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月23日 上午11:39:23 
	 *
	 * @Return       : MediaApiDto
	 */
	public static TempMediaApiDto uploadTempMedia(String accessToken, MediaType type, File File) throws WechatException, WebServiceException {
		WechatApiResponse response = WechatMediaApiCaller.uploadTempMedia(accessToken, type, File);
		JSONObject rootNode = response.getRootJSONObj();
        
		TempMediaApiDto dto = new TempMediaApiDto();
		dto.setMediaId( rootNode.getString("media_id") );
		dto.setType( rootNode.getString("type") );
		dto.setCreatedAt( rootNode.getLong("created_at") );
		return dto;
    }
	
	/**
	 * @Description  : 下载临时素材
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月23日 上午11:42:23 
	 *
	 * @Return       : byte[]
	 * 连个文件类型都没有 这api不好用啊
	 */
	public static byte[] downloadTempMedia(String accessToken, String mediaId)  throws WechatException, WebServiceException, Exception {
        return WechatMediaApiCaller.downloadTempMedia(accessToken, mediaId);
    }
	
	
	/**
	 * @Description  : 上传永久素材
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月24日 下午4:05:14 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static WechatApiResponse uploadPermanentMedia(String accessToken, MediaType type, File file){
		return WechatMediaApiCaller.uploadPermanentMedia(accessToken, type, file);
	}
	
	
	/**
	 * @Description  : 上传永久图片素材
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月3日 上午10:59:42 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static PermanentMediaApiDto uploadPermanentMediaImage(String accessToken, File file){
		WechatApiResponse response =  WechatMediaApiCaller.uploadPermanentMedia(accessToken, MediaType.IMAGE, file);
		
		JSONObject rootNode = response.getRootJSONObj();
		PermanentMediaApiDto dto = new PermanentMediaApiDto();
		dto.setMediaId( rootNode.getString("media_id") );
		dto.setUrl(  rootNode.getString("url") );
		return dto;
	}
	
	
	/**
	 * @Description  : 上传永久图文素材
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月24日 下午4:05:17 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static PermanentMediaApiDto uploadPermanentNews(String accessToken, String json){
		WechatApiResponse response =  WechatMediaApiCaller.uploadPermanentNews(accessToken, json);
		
		JSONObject rootNode = response.getRootJSONObj();
		PermanentMediaApiDto dto = new PermanentMediaApiDto();
		dto.setMediaId( rootNode.getString("media_id") );
		return dto;
	}
	
	
	
	/**
	 * @Description  : 获取微信素材总数
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月2日 下午9:55:15 
	 *
	 * @Return       : MediaCountDto
	 */
	public static MediaCountDto countPermanentMedia(String accessToken){
		MediaCountDto dto = new MediaCountDto();
		
		WechatApiResponse response = WechatMediaApiCaller.countPermanentMedia(accessToken);
		JSONObject rootNode = response.getRootJSONObj();
		dto.setImageCount( rootNode.optInt("image_count",0) );
		dto.setNewsCount( rootNode.optInt("news_count",0) );
		dto.setVideoCount( rootNode.optInt("video_count",0) );
		dto.setVoiceCount( rootNode.optInt("voice_count",0) );
		
		return dto;
	}
	
	
	/**
	 * @Description  : 查询图文素材
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月2日 下午9:55:42 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static WechatApiResponse batchGetPermanentMediaNews(String accessToken, int offset, int count){
		return WechatMediaApiCaller.batchGetPermanentMedia(accessToken, MediaType.NEWS, offset, count);
	}
	
	
	public static WechatApiResponse getPermanentMediaNews(String accessToken, String mediaId){
		return WechatMediaApiCaller.getPermanentMediaNews(accessToken, mediaId);
	}

	
	
	/**
	 * @Description  : 下载永久素材
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月4日 下午8:28:20 
	 *
	 * @Return       : byte[]
	 */
	public static byte[] downloadPermanentMedia(String accessToken,String mediaId) throws Exception{
        return WechatMediaApiCaller.downloadPermanentMedia(accessToken, mediaId);
	}
	
	
	
	/**
	 * @Description  : 删除永久素材
	 * @Author       : zhenyujian
	 * @Date         : 2016年3月21日 下午5:29:08 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static WechatApiResponse delPermanentMediaNews(String accessToken,String mediaId){
		return WechatMediaApiCaller.delPermanentMediaNews(accessToken, mediaId);
	}
	
	
	/**
	 * @Description  : 上传图文素材正文中的图片
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月24日 下午4:05:17 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static String uploadPermanentMediaNewsImg(String accessToken, File file){
		WechatApiResponse response = WechatMediaApiCaller.uploadPermanentMediaNewsImg(accessToken, file);
		JSONObject rootNode = response.getRootJSONObj();
		return rootNode.optString("url","");
	}
}

